#!/bin/bash
#
#SBATCH --partition=a40         # GPU partition to use
#SBATCH --gres gpu:2            # Number of GPUs per job
#SBATCH -c 16                   # Number of cores
#SBATCH -N 1                    # Ensure that all cores are on one machine
#SBATCH -t 0-12:00              # Maximum run-time in D-HH:MM
#SBATCH --mem=96G               # Memory pool for all cores (see also --mem-per-cpu)
#SBATCH -o logs/2a40_%j.out     # File to which STDOUT will be written
#SBATCH -e logs/2a40_%j.out     # File to which STDERR will be written

scripts/slurm/run.sh "$@"
