#!/bin/bash

# Usage:
#
# Use ./sync.sh to-svr <folder> to upload the contents of <folder> to the server
# Use ./sync.sh from-svr <folder> to download the contents of <folder> from the server
# <folder> is the name of the project directory both locally and on the server
# Add "dry" to simulate a dry run.


# NFS directory under which project folders should be located on the server
SERVER_DIR="<redacted>"
# Local directory where your projects are located
WORKSPACE_DIR="$HOME/projects/llms/code"

# Command aliases
TO_SERVER="to-svr"
FROM_SERVER="from-svr"
DRY="dry"

DIRECTION=$1
DIRECTORY=$2
if [ "$1" == "$TO_SERVER" ]; then
    # Add trailing slash to only copy the contents of the source directory
    SRC="$WORKSPACE_DIR/$DIRECTORY"
    DST="$SERVER_DIR/$DIRECTORY"
elif [ "$1" == "$FROM_SERVER" ]; then
    # Add trailing slash to only copy the contents of the source directory
    SRC="$SERVER_DIR/$DIRECTORY"
    DST="$WORKSPACE_DIR/$DIRECTORY"
fi

FLAGS="-avu --delete"

if [[ "$#" -ge 3 ]] && [[ "$3" == "$DRY" ]]; then
    FLAGS+=" --dry-run"
fi

echo "$SRC"
echo "$DST"
echo "$DR_FLAG"

#rsync -av --delete -f "+ */" -f"+ *.py" -f"+ */data/" -f"- .*" -f"- *{(.o)(.d)(.pyc)(.sat)(.out)" -e ssh $SRC $DST
rsync $FLAGS --exclude-from='.rsync_exclude_list.txt' -e ssh $SRC $DST
