# Safeguard User Privacy in LLM Cloud Services

This is the code used to reproduce the experimental results of our paper, which is submitted to ICLR 2025,
and they will be open-sourced if the paper is accepted.

![](figures/fig1.png)

## Requirements:
### dependencies
We list the minimal environment in `minimal_environment.yml`.

### GPUs
We use NVIDIA GeForce RTX 4090 for the experiments.


## Usage
Please prepare the datasets and models before running the code. 

### Datasets and Models
We use following datasets: *GSM8K*, *HumanEval*, *MMLU*, *BBH*, *BoolQ*, *HellaSwag*.

We use following models: *Meta-Llama-3-8B-Instruct*, *Mistral-7B-Instruct-v0.3*, *gemma-2-9b-it*,
*Phi-3-medium-128k-instruct*, *Meta-Llama-3-70B-Instruct-AWQ*.

If you want to reproduce the results in the paper, please download corresponding datasets and models.


### Attack and Evaluation
We have designed an easy interaction, and you can run attack directly:
```
python optimization_attack.py
```
Default model is *gemma-2-9b-it* and you can change it by manually.

For the evaluation, you can run these manuscripts directly.

| manuscript             | parameters that can be adjusted       |
|------------------------|---------------------------------------|
| eva_boolq.py           | str: model_path, bool: enable_privacy |
| eva_gsm8k.py           | str: model_path, bool: enable_privacy |
| eva_hellaswag.py       | str: model_path, bool: enable_privacy |
| eva_humaneval.py       | str: model_path, bool: enable_privacy |
| eva_humaneval_llama.py | bool: enable_privacy                  |
| eva_BBH.py             | str: model_path, bool: enable_privacy |
| eva_MMLU.py            | str: model_path, bool: enable_privacy |

## License
For the license of our code, refer to `LICENSE.md`.

## Authors
Authors are anonymous for double-blind reviewing.
