import datasets


def report(
    reconstructed_user_data,
    true_user_data,
):
    print("Starting evaluations for attack effectiveness report...")
    modality_metrics = _calculate_rouge(
        reconstructed_user_data, true_user_data
    )
    m = modality_metrics
    print(
        f"METRICS: | ROUGE1: {m['rouge1']:4.2f}| ROUGE2: {m['rouge2']:4.2f} | ROUGE-L: {m['rougeL']:4.2f}"
    )
    metrics = dict(
        **modality_metrics,
    )
    return metrics


def _calculate_rouge(reconstructed_user_data, true_user_data):
    text_metrics = dict()
    metric = datasets.load_metric("rouge")
    rec_sentence = reconstructed_user_data
    ref_sentence = true_user_data
    score = metric.compute(predictions=rec_sentence, references=ref_sentence)
    text_metrics["rouge1"] = score["rouge1"].mid.fmeasure
    text_metrics["rouge2"] = score["rouge2"].mid.fmeasure
    text_metrics["rougeL"] = score["rougeL"].mid.fmeasure
    return text_metrics
