/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.process.WordSegmenter;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class WordSegmentingTokenizer
extends AbstractTokenizer<HasWord> {
    private Iterator<HasWord> wordIter;
    private Tokenizer<CoreLabel> tok;
    private WordSegmenter wordSegmenter;

    public WordSegmentingTokenizer(WordSegmenter segmenter, Reader r) {
        this(segmenter, WhitespaceTokenizer.newCoreLabelWhitespaceTokenizer(r));
    }

    public WordSegmentingTokenizer(WordSegmenter segmenter, Tokenizer<CoreLabel> tokenizer) {
        this.wordSegmenter = segmenter;
        this.tok = tokenizer;
    }

    @Override
    protected HasWord getNext() {
        while (this.wordIter == null || !this.wordIter.hasNext()) {
            List<HasWord> se;
            if (!this.tok.hasNext()) {
                return null;
            }
            CoreLabel token = (CoreLabel)this.tok.next();
            String s = token.word();
            if (s == null) {
                return null;
            }
            if (s.equals("*NL*")) {
                se = Collections.singletonList(token);
                this.wordIter = se.iterator();
                continue;
            }
            se = this.wordSegmenter.segment(s);
            this.wordIter = se.iterator();
        }
        return this.wordIter.next();
    }

    public static TokenizerFactory<HasWord> factory(WordSegmenter wordSegmenter) {
        return new WordSegmentingTokenizerFactory(wordSegmenter);
    }

    private static class WordSegmentingTokenizerFactory
    implements TokenizerFactory<HasWord>,
    Serializable {
        private static final long serialVersionUID = -4697961121607489828L;
        boolean tokenizeNLs = false;
        private WordSegmenter segmenter;

        public WordSegmentingTokenizerFactory(WordSegmenter wordSegmenter) {
            this.segmenter = wordSegmenter;
        }

        @Override
        public Iterator<HasWord> getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        @Override
        public Tokenizer<HasWord> getTokenizer(Reader r) {
            return this.getTokenizer(r, null);
        }

        @Override
        public Tokenizer<HasWord> getTokenizer(Reader r, String extraOptions) {
            boolean tokenizeNewlines = this.tokenizeNLs;
            if (extraOptions != null) {
                Properties prop = StringUtils.stringToProperties(extraOptions);
                tokenizeNewlines = PropertiesUtils.getBool(prop, "tokenizeNLs", this.tokenizeNLs);
            }
            return new WordSegmentingTokenizer(this.segmenter, WhitespaceTokenizer.newCoreLabelWhitespaceTokenizer(r, tokenizeNewlines));
        }

        @Override
        public void setOptions(String options) {
            Properties prop = StringUtils.stringToProperties(options);
            this.tokenizeNLs = PropertiesUtils.getBool(prop, "tokenizeNLs", this.tokenizeNLs);
        }
    }
}

