/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.AnnotationLookup;
import edu.stanford.nlp.ling.CoreAnnotation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Env
implements Serializable {
    private static final long serialVersionUID = -4168610545399833956L;
    private final Map<String, Object> variables;

    public Env() {
        this.variables = new HashMap<String, Object>();
    }

    public Env(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void bind(String name, Object obj) {
        if (obj != null) {
            this.variables.put(name, obj);
        } else {
            this.variables.remove(name);
        }
    }

    public void unbind(String name) {
        this.bind(name, null);
    }

    public Object get(String name) {
        return this.variables.get(name);
    }

    public static Class lookupAnnotationKey(Env env, String name) {
        Object obj;
        if (env != null && (obj = env.get(name)) != null && obj instanceof Class) {
            return (Class)obj;
        }
        Class<? extends CoreAnnotation<?>> coreKeyClass = AnnotationLookup.toCoreKey(name);
        if (coreKeyClass != null) {
            return coreKeyClass;
        }
        try {
            Class<?> clazz = Class.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

