#!/bin/bash
set -e # stop on error
# add parent to python path
export PYTHONPATH="../":"${PYTHONPATH}"
export CUDA_VISIBLE_DEVICES=0

SECONDS=0
SAMPLES=-1
BS=1000

# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/LORE-d0.1-k10-imagenet-5epoch/clean  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-L-14/LORE-d0.1-k10-imagenet-5600step/clean  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-L-14/CLIP  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/FARE4/clean  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-L-14/LORE-d0.1-k10-imagenet-main2-continue/clean  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE4/clean  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/FARE_bench_official/clean  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-L-14/last_checkp/clean  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE1_k5_Step4000/clean  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE_Sched
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE_Relu
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/final
SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/large_eps
mkdir -p "$SAVE_DIR"
python /YOUR_ROOT_PATH/CLIP_benchmark/_29sep/run_hh.py eval --dataset_root "https://huggingface.co/datasets/clip-benchmark/wds_{dataset_cleaned}/tree/main" --dataset /YOUR_ROOT_PATH/CLIP_benchmark/benchmark/datasets.txt \
    --pretrained_model /YOUR_ROOT_PATH/CLIP_benchmark/benchmark/models.txt \
    --output "${SAVE_DIR}/clean_{model}_{pretrained}_beta{beta}_{dataset}_{n_samples}_bs{bs}_{attack}_{eps}_{iterations}.json" \
    --attack none --eps 1 \
    --batch_size $BS --n_samples $SAMPLES \

hours=$((SECONDS / 3600))
minutes=$(( (SECONDS % 3600) / 60 ))
echo "[Runtime] $hours h $minutes min"