#!/bin/bash
# TODO : for eps1,2
# adjust these parameters
export CUDA_VISIBLE_DEVICES=4,5,6,7
experiment_NAME="pgd_eps2"                 # don't add model or dataset name in this name 
dataset_NAME="imagenet100"                 # imagenet or imagenet100
model_NAME="ViT-B-32"                      # ViT-B-32 or ViT-L-14
mode="final"                               # setup or final   
loss_type="linf"                           # l2 , ce , kl, linf

if [ "$mode" == "setup" ]; then
    wandb=False
elif [ "$mode" == "final" ]; then
    wandb=True
else
    echo "who are you?"
    exit 1
fi

if [ "$model_NAME" == "ViT-L-14" ]; then
    per_device_batch_size=32
elif [ "$model_NAME" == "ViT-B-32" ]; then
    per_device_batch_size=448
else
    echo "Unknown model name: $model_NAME"
    exit 1
fi

if [ "$dataset_NAME" == "imagenet" ]; then
    dataset_root=/YOUR_ROOT_PATH/data/ILSVRC/Data/CLS-LOC
elif [ "$dataset_NAME" == "imagenet100" ]; then
    dataset_root=/YOUR_ROOT_PATH/data/imagenet100/data
else
    echo "Unknown model name: $model_NAME"
    exit 1
fi


# Array of logarithmically spaced rho values from 1e-3 to 1
# rho_values=(0.05 0.1 0.2 0.5 1.0)
rho_values=(0.1)

echo 'Start training!'

for rho in "${rho_values[@]}"
do
    # Update experiment name to include rho value
    EXPERIMENT_NAME="${experiment_NAME}_rho${rho}"
    
    echo "Starting run with rho = ${rho}"
    echo "Experiment name: ${EXPERIMENT_NAME}"
    
    python3 /YOUR_ROOT_PATH/src/train/adversarial_LORE.py \
        --clip_model_name ${model_NAME} \
        --pretrained openai \
        --dataset ${dataset_NAME} \
        --imagenet_root $dataset_root \
        --template std \
        --output_normalize False \
        --steps 1440 \
        --warmup 150 \
        --per_device_batch_size $per_device_batch_size \
        --loss $loss_type \
        --loss_clean $loss_type \
        --inner_loss $loss_type \
        --opt adamw \
        --lr 1e-5 \
        --wd 1e-4 \
        --attack pgd \
        --norm linf \
        --rho ${rho} \
        --clean_weight 0 \
        --eps 2 \
        --iterations_adv 10 \
        --stepsize_adv 1 \
        --wandb $wandb \
        --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
        --experiment_name ${EXPERIMENT_NAME} \
        --log_freq 10 \
        --eval_freq 10 \
        --online True \
        --k_iter 5 \
        --lambda_net linear_mlp \
        --anchor_option orig \
        --grad_norm 1.0 \
        --lambda_lr 5e-4 \
        --rho_scheduler const
    
    echo "Finished run with rho = ${rho}"
    echo "-----------------------------------"
done

echo 'All runs completed successfully' 