from .utils import init_wandb, AverageMeter, str2bool
from .pgd_train import pgd
from .apgd_train import apgd_train as apgd
import importlib.util
import os
import sys

# Add the project root directory (parent of the train folder) to sys.path
current_dir = os.path.dirname(os.path.abspath(__file__))
parent_dir = os.path.dirname(current_dir)
if parent_dir not in sys.path:
    sys.path.insert(0, parent_dir)

# Dynamically load the module from "adversarial_train-main2.py"
module_path = os.path.join(current_dir, "adversarial_LORE.py")
spec = importlib.util.spec_from_file_location("adversarial_LORE", module_path)
adversarial_train_main2 = importlib.util.module_from_spec(spec)
spec.loader.exec_module(adversarial_train_main2)

# Import required symbols from the dynamically loaded module
ComputeLossWrapper = adversarial_train_main2.ComputeLossWrapper
get_dataset = adversarial_train_main2.get_dataset
COCOFlickrDataset = adversarial_train_main2.COCOFlickrDataset
ImageNetDataset = adversarial_train_main2.ImageNetDataset

from .sam_data import SamData

__all__ = [
    "init_wandb",
    "AverageMeter",
    "str2bool",
    "pgd",
    "apgd",
    "ComputeLossWrapper",
    "get_dataset",
    "COCOFlickrDataset",
    "ImageNetDataset",
    "SamData"
] 