#!/bin/bash
set -e # stop on error
SECONDS=3
# add parent dir to python path
export PYTHONPATH="../":"${PYTHONPATH}"
export CUDA_VISIBLE_DEVICES=2
EPS=10

SAMPLES=1000
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/FARE_bench_official/adv  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-L-14/LORE-d0.1-k10-imagenet-main2-continue/adv  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE-d0.1-k10-imagenet-5epoch/adv  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE4/adv  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-L-14/last_checkp/adv  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE1_k5_Step4000/adv  # TODO
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE_Sched
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/LORE_Relu
# SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/final
SAVE_DIR=/YOUR_ROOT_PATH/CLIP_benchmark/results/ViT-B-32/large_eps
mkdir -p "$SAVE_DIR"
python /YOUR_ROOT_PATH/CLIP_benchmark/_29sep/run_hh.py eval --dataset_root "https://huggingface.co/datasets/clip-benchmark/wds_{dataset_cleaned}/tree/main" --dataset /YOUR_ROOT_PATH/CLIP_benchmark/benchmark/datasets.txt \
    --pretrained_model /YOUR_ROOT_PATH/CLIP_benchmark/benchmark/models.txt \
    --output "${SAVE_DIR}/adv2_{model}_{pretrained}_{dataset}_{n_samples}_bs{bs}_{attack}_{eps}_{iterations}.json" \
    --attack aa --eps $EPS --iterations_adv 100 \
    --batch_size 50 --n_samples $SAMPLES

hours=$((SECONDS / 3600))
minutes=$(( (SECONDS % 3600) / 60 ))
echo "[Runtime] $hours h $minutes min"