#!/bin/bash

# adjust these parameters
export CUDA_VISIBLE_DEVICES=4,5,6,7
experiment_NAME="pgd_LORE"                # don't add model or dataset name in this name 
dataset_NAME="imagenet"                    # imagenet or imagenet100
model_NAME="ViT-B-32"                      # ViT-B-32 or ViT-L-14
mode="setup"                               # setup or final   
loss_type="l2"                             # l2 , ce , kl

if [ "$mode" == "setup" ]; then
    wandb=False
elif [ "$mode" == "final" ]; then
    wandb=True
else
    echo "who are you?"
    exit 1
fi

if [ "$model_NAME" == "ViT-L-14" ]; then
    per_device_batch_size=32
elif [ "$model_NAME" == "ViT-B-32" ]; then
    per_device_batch_size=448
else
    echo "Unknown model name: $model_NAME"
    exit 1
fi


echo 'Start training!'

# rho_values=(2) #  2 4)
rho_values=(1 2 3 4 5) 
all_corruption=(brightness contrast defocus_blur elastic_transform fog frost gaussian_blur gaussian_noise glass_blur impulse_noise jpeg_compression motion_blur pixelate saturate shot_noise snow spatter speckle_noise zoom_blur)

for corruption in "${all_corruption[@]}"
do
for rho in "${rho_values[@]}"
do
    # Update experiment name to include rho value
    EXPERIMENT_NAME="${experiment_NAME}_eps${rho}"
    
    echo "Starting run with eps = ${rho}"
    echo "Experiment name: ${EXPERIMENT_NAME}"

    # Use the variable in the command
    python3 /YOUR_ROOT_PATH/src/train/adversarial_LORE_imagenet_c.py \
        --clip_model_name ${model_NAME} \
        --pretrained openai \
        --dataset imagenet_c \
        --imagenet_root /YOUR_ROOT_PATH/data/Imagenet-C/img \
        --template std \
        --output_normalize False \
        --steps 6000 \
        --warmup 550 \
        --per_device_batch_size $per_device_batch_size \
        --loss $loss_type \
        --loss_clean $loss_type \
        --inner_loss $loss_type \
        --opt adamw \
        --lr 1e-5 \
        --wd 1e-4 \
        --attack pgd \
        --norm linf \
        --rho 8e-2 \
        --clean_weight 0 \
        --eps 2 \
        --iterations_adv 10 \
        --stepsize_adv 1 \
        --wandb $wandb \
        --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
        --experiment_name ${EXPERIMENT_NAME} \
        --log_freq 10 \
        --eval_freq 10 \
        --online True \
        --k_iter 5 \
        --lambda_net linear_mlp \
        --anchor_option orig \
        --grad_norm 1.0 \
        --lambda_lr 5e-4 \
        --rho_scheduler const \
        --return_clean_dis_freq 40 \
        --corruption_type $corruption \
        --corruption_level $rho \
        --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_FARE_base_eps2_j1vwo 
        
        
    # Use the variable in the command
    python3 /YOUR_ROOT_PATH/src/train/adversarial_LORE_imagenet_c.py \
        --clip_model_name ${model_NAME} \
        --pretrained openai \
        --dataset imagenet_c \
        --imagenet_root /YOUR_ROOT_PATH/data/Imagenet-C/img \
        --template std \
        --output_normalize False \
        --steps 6000 \
        --warmup 550 \
        --per_device_batch_size $per_device_batch_size \
        --loss $loss_type \
        --loss_clean $loss_type \
        --inner_loss $loss_type \
        --opt adamw \
        --lr 1e-5 \
        --wd 1e-4 \
        --attack pgd \
        --norm linf \
        --rho 8e-2 \
        --clean_weight 0 \
        --eps 2 \
        --iterations_adv 10 \
        --stepsize_adv 1 \
        --wandb $wandb \
        --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
        --experiment_name ${EXPERIMENT_NAME} \
        --log_freq 10 \
        --eval_freq 10 \
        --online True \
        --k_iter 5 \
        --lambda_net linear_mlp \
        --anchor_option orig \
        --grad_norm 1.0 \
        --lambda_lr 5e-4 \
        --rho_scheduler const \
        --return_clean_dis_freq 40 \
        --corruption_type $corruption \
        --corruption_level $rho \
        --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps2_h2oJA 
        
    python3 /YOUR_ROOT_PATH/src/train/adversarial_LORE_imagenet_c.py \
        --clip_model_name ${model_NAME} \
        --pretrained openai \
        --dataset imagenet_c \
        --imagenet_root /YOUR_ROOT_PATH/data/Imagenet-C/img \
        --template std \
        --output_normalize False \
        --steps 6000 \
        --warmup 550 \
        --per_device_batch_size $per_device_batch_size \
        --loss $loss_type \
        --loss_clean $loss_type \
        --inner_loss $loss_type \
        --opt adamw \
        --lr 1e-5 \
        --wd 1e-4 \
        --attack pgd \
        --norm linf \
        --rho 8e-2 \
        --clean_weight 0 \
        --eps 2 \
        --iterations_adv 10 \
        --stepsize_adv 1 \
        --wandb $wandb \
        --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
        --experiment_name ${EXPERIMENT_NAME} \
        --log_freq 10 \
        --eval_freq 10 \
        --online True \
        --k_iter 5 \
        --lambda_net linear_mlp \
        --anchor_option orig \
        --grad_norm 1.0 \
        --lambda_lr 5e-4 \
        --rho_scheduler const \
        --return_clean_dis_freq 40 \
        --corruption_level $rho \
        --corruption_type $corruption 
        # --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps2_h2oJA 
        

    echo "Finished run with eps = ${rho}"
    echo "-----------------------------------"
done
done

echo 'All runs completed successfully' 