#!/bin/bash

# adjust these parameters
export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
experiment_NAME="pgd_LORE"                # don't add model or dataset name in this name 
dataset_NAME="imagenet"                    # imagenet or imagenet100
model_NAME="ViT-B-32"                      # ViT-B-32 or ViT-L-14
mode="setup"                               # setup or final   
loss_type="l2"                             # l2 , ce , kl

if [ "$mode" == "setup" ]; then
    wandb=False
elif [ "$mode" == "final" ]; then
    wandb=True
else
    echo "who are you?"
    exit 1
fi

if [ "$model_NAME" == "ViT-L-14" ]; then
    per_device_batch_size=32
elif [ "$model_NAME" == "ViT-B-32" ]; then
    per_device_batch_size=16 # 448
else
    echo "Unknown model name: $model_NAME"
    exit 1
fi

if [ "$dataset_NAME" == "imagenet" ]; then
    dataset_root=/YOUR_ROOT_PATH/data/ILSVRC/Data/CLS-LOC
elif [ "$dataset_NAME" == "imagenet100" ]; then
    dataset_root=/YOUR_ROOT_PATH/data/imagenet100/data
else
    echo "Unknown model name: $model_NAME"
    exit 1
fi

echo 'Start training!'

# Update experiment name to include rho value
EXPERIMENT_NAME="${experiment_NAME}_eps1"


# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 1 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 
    # --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps2_h2oJA \

# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 1 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps1_kTk9z 



# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 2 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps2_h2oJA 

python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 4 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps1.5e-1_KU28M 



# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 6 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps6_tbQvA 



# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 8 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps8_DSOUa 

python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 10 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_LORE_base_eps10_cjSS8 



#######################################################33
## FARE
#######################################################33

# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 1 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_FARE_base_eps1_vnbyu 



# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 2 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_FARE_base_eps2_j1vwo 

python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 4 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_FARE_base_eps4_ZjXQW 




# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 6 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_FARE_base_eps6_izJce 



# Use the variable in the command
python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 8 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_FARE_base_eps8_pDe5N 

python3 /YOUR_ROOT_PATH/CLIP_eval/interpretability_improvement.py \
    --clip_model_name ${model_NAME} \
    --pretrained openai \
    --dataset ${dataset_NAME} \
    --imagenet_root $dataset_root \
    --template std \
    --output_normalize False \
    --steps 6000 \
    --warmup 550 \
    --per_device_batch_size $per_device_batch_size \
    --loss $loss_type \
    --loss_clean $loss_type \
    --inner_loss $loss_type \
    --opt adamw \
    --lr 1e-5 \
    --wd 1e-4 \
    --attack pgd \
    --norm linf \
    --rho 8e-2 \
    --clean_weight 0 \
    --eps 10 \
    --iterations_adv 10 \
    --stepsize_adv 1 \
    --wandb $wandb \
    --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
    --experiment_name ${EXPERIMENT_NAME} \
    --log_freq 10 \
    --eval_freq 10 \
    --online True \
    --k_iter 5 \
    --lambda_net linear_mlp \
    --anchor_option orig \
    --grad_norm 1.0 \
    --lambda_lr 5e-4 \
    --rho_scheduler const \
    --return_clean_dis_freq 40 \
    --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/final/ViT-B-32-imagenet/ViT-B-32_openai_imagenet_l2_pgd_FARE_base_eps10_eDNO6 


echo 'All runs completed successfully' 