#!/bin/bash

# adjust these parameters
export CUDA_VISIBLE_DEVICES=4,5,6,7
experiment_NAME="pgd_FARE_LAION"                # don't add model or dataset name in this name 
dataset_NAME="imagenet100"                    # imagenet or imagenet100
model_NAME="ViT-B-32-laion2B"                      # ViT-B-32 or ViT-L-14
mode="final"                               # setup or final   

if [ "$mode" == "setup" ]; then
    wandb=False
elif [ "$mode" == "final" ]; then
    wandb=True
else
    echo "who are you?"
    exit 1
fi

if [ "$model_NAME" == "ViT-L-14" ]; then
    per_device_batch_size=32
elif [ "$model_NAME" == "ViT-B-32" ]; then
    per_device_batch_size=448
elif [ "$model_NAME" == "ViT-B-32-laion2B" ]; then
    per_device_batch_size=448
elif [ "$model_NAME" == "ViT-B-32-convnext" ]; then
    per_device_batch_size=64
else
    echo "Unknown model name: $model_NAME"
    exit 1
fi

if [ "$dataset_NAME" == "imagenet" ]; then
    dataset_root=/YOUR_ROOT_PATH/data/ILSVRC/Data/CLS-LOC
elif [ "$dataset_NAME" == "imagenet100" ]; then
    dataset_root=/YOUR_ROOT_PATH/data/imagenet100/data
else
    echo "Unknown model name: $dataset_NAME"
    exit 1
fi

echo 'Start training!'

rho_values=(2) #0.1 0.8 0.05 0.15) 

for rho in "${rho_values[@]}"
do
    # Update experiment name to include rho value
    EXPERIMENT_NAME="${experiment_NAME}_eps${rho}"
    
    echo "Starting run with eps = ${rho}"
    echo "Experiment name: ${EXPERIMENT_NAME}"

    # Use the variable in the command
    python3 /YOUR_ROOT_PATH/src/train/adversarial_FARE.py \
        --clip_model_name $model_NAME \
        --pretrained openai \
        --dataset ${dataset_NAME} \
        --imagenet_root $dataset_root \
        --template std \
        --output_normalize False \
        --steps 1440 \
        --warmup 150 \
        --per_device_batch_size $per_device_batch_size \
        --loss l2 \
        --loss_clean l2 \
        --inner_loss l2 \
        --opt adamw \
        --lr 1e-5 \
        --wd 1e-4 \
        --attack pgd \
        --norm linf \
        --clean_weight 0 \
        --eps ${rho} \
        --iterations_adv 10 \
        --stepsize_adv 1 \
        --wandb $wandb \
        --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
        --experiment_name ${EXPERIMENT_NAME} \
        --log_freq 10 \
        --eval_freq 10 \
        --online True 


    echo "Finished run with eps = ${rho}"
    echo "-----------------------------------"
done

echo 'All runs completed successfully' 