#!/bin/bash

# adjust these parameters
export CUDA_VISIBLE_DEVICES=0,1,2,3,4
experiment_NAME="pgd_LORE_other_models"                # don't add model or dataset name in this name 
dataset_NAME="imagenet"                    # imagenet or imagenet100
mode="setup"                               # setup or final   
loss_type="l2"                             # l2 , ce , kl

if [ "$mode" == "setup" ]; then 
    wandb=False
elif [ "$mode" == "final" ]; then 
    wandb=True
else
    echo "who are you?"
    exit 1
fi

if [ "$dataset_NAME" == "imagenet" ]; then
    dataset_root=/YOUR_ROOT_PATH/data/ILSVRC/Data/CLS-LOC
elif [ "$dataset_NAME" == "imagenet100" ]; then
    dataset_root=/YOUR_ROOT_PATH/data/imagenet100/data
else
    echo "Unknown model name: $dataset_NAME"
    exit 1
fi

echo 'Start training!'

rho_values=(1 2 4)
all_models=('ViT-B-16' 'ViT-B-16-laion2B' 'ViT-B-32-laion2B')

for model_NAME in "${all_models[@]}"
do 
    if [ "$model_NAME" == "ViT-L-14" ]; then
        per_device_batch_size=32
    elif [ "$model_NAME" == "ViT-B-32" ]; then
        per_device_batch_size=448
    elif [ "$model_NAME" == "ViT-B-16" ]; then
        per_device_batch_size=448 # TODO
    elif [ "$model_NAME" == "ViT-B-16-laion2B" ]; then
        per_device_batch_size=448 # TODO
    elif [ "$model_NAME" == "ViT-B-32-laion2B" ]; then
        per_device_batch_size=448 # TODO
    else
        echo "Unknown model name: $model_NAME"
        exit 1
    fi

    for rho in "${rho_values[@]}"
    do
        # Update experiment name to include rho value
        EXPERIMENT_NAME="${experiment_NAME}_eps${rho}"
        
        echo "Starting run with eps = ${rho}"
        echo "Experiment name: ${EXPERIMENT_NAME}"

        # Use the variable in the command
        python3 /YOUR_ROOT_PATH/src/train/adversarial_LORE.py \
            --clip_model_name ${model_NAME} \
            --pretrained openai \
            --dataset ${dataset_NAME} \
            --imagenet_root $dataset_root \
            --template std \
            --output_normalize False \
            --steps 6000 \
            --warmup 550 \
            --per_device_batch_size $per_device_batch_size \
            --loss $loss_type \
            --loss_clean $loss_type \
            --inner_loss $loss_type \
            --opt adamw \
            --lr 1e-5 \
            --wd 1e-4 \
            --attack pgd \
            --norm linf \
            --rho 8e-2 \
            --clean_weight 0 \
            --eps ${rho} \
            --iterations_adv 10 \
            --stepsize_adv 1 \
            --wandb $wandb \
            --output_dir /YOUR_ROOT_PATH/checkpoints/$mode/$model_NAME-$dataset_NAME \
            --experiment_name ${EXPERIMENT_NAME} \
            --log_freq 10 \
            --eval_freq 10 \
            --online True \
            --k_iter 5 \
            --lambda_net linear_mlp \
            --anchor_option orig \
            --grad_norm 1.0 \
            --lambda_lr 5e-4 \
            --rho_scheduler const \
            --return_clean_dis_freq 40
            # --checkpoint_dir /YOUR_ROOT_PATH/checkpoints/ViT-L-14-CIFAR10/ViT-L-14_openai_imagenet_l2_imagenet_ViT-L-main2_CmSro \
            # --start_step 5800 \ 

        echo "Finished run with eps = ${rho}"
        echo "-----------------------------------"
    done
done 

echo 'All runs completed successfully' 