from __future__ import annotations

from typing import Any, Protocol


Data = Any
Latent = Any



class Encoder(Protocol):
    def __call__(self, data: Data) -> Latent: ...


class Decoder(Protocol):
    def __call__(self, latent: Latent) -> Data: ...


def identity(encoder: Encoder,
             decoder: Decoder,
             data: Data) -> Data:
    z = encoder(data)
    reconstruction = decoder(z)

    return reconstruction, data
