# Visual Object-Centric Counterfactual Explanations (VOCCE) - Code Appendix

Implementation code for **"Visual Object-Centric Counterfactual Explanations"** submitted to ICLR 2026.

## Method Overview

VOCCE generates counterfactual explanations by:
1. Decomposing images into object-centric latent slots
2. Using classifier gradients to guide reverse diffusion 
3. Applying GMM regularization to maintain realism

## Repository Structure

```
code_appendix/
├── README.md                   # This file
├── requirements.txt            # Python dependencies
├── configs/                    # Dataset configurations
│   ├── clevrtex/              # ClevrTex experiments
│   ├── faces/                 # FFHQ/CelebA-HQ experiments  
│   └── counterfactuals/       # Counterfactual generation
└── src/                       # Source code
    ├── train_lsd.py           # Main LSD training (Section 3.1)
    ├── gen_counterfactuals.py # VOCCE implementation (Section 3)
    ├── slot_attn.py           # Slot attention mechanism (Section 3.1)
    ├── backbone.py            # UNet encoder backbone
    ├── unet_with_pos.py       # UNet with positional embeddings
    ├── classifier.py          # Target classifier training
    ├── pipelines.py           # Diffusion pipelines
    ├── data.py                # Dataset loading
    ├── utils.py               # Utility functions
    └── parser.py              # Argument parsing
```

