#!/bin/bash

# Activate conda environment - adjust path as needed
source ~/miniconda3/etc/profile.d/conda.sh
conda activate lsd  # replace 'lsd' with your environment name

# Run the training script with regular Python
CUDA_VISIBLE_DEVICES=0 python train_lsd.py \
--dataloader_num_workers 8 --learning_rate 1e-4 \
--mixed_precision bf16 --num_validation_images 32 --val_batch_size 32 --max_train_steps 300000 \
--checkpointing_steps 25000 --checkpoints_total_limit 2 --gradient_accumulation_steps 1 \
--seed 39 --encoder_lr_scale 0.3 --train_split_portion 0.9 \
--output_dir /logs/clevrtex/lsd_another_attempt \
--backbone_config /configs/clevrtex/backbone/config.json \
--slot_attn_config /configs/clevrtex/slot_attn/config.json \
--unet_config /configs/clevrtex/unet/config.json \
--scheduler_config /configs/clevrtex/scheduler/scheduler_config.json \
--dataset_root /clevrtexv2_full/images/ \
--dataset_glob '*.png' --train_batch_size 64 --resolution 128 --validation_steps 5000 \
--tracker_project_name latent_slot_diffusion \
--tracker_experiment_name clevrtex_lsd_another_attempt \
--use_slot_conditioning \
--allow_tf32