#!/bin/bash

# Activate conda environment - adjust path as needed
source ~/miniconda3/etc/profile.d/conda.sh
conda activate lsd  # replace 'lsd' with your environment name

CUDA_VISIBLE_DEVICES=2,3 accelerate launch --multi_gpu --num_processes=2 --main_process_port 28500 train_lsd.py \
--dataloader_num_workers 8 --learning_rate 1e-4 \
--mixed_precision bf16 --num_validation_images 32 --val_batch_size 32 --max_train_steps 300000 \
--checkpointing_steps 25000 --checkpoints_total_limit 2 --gradient_accumulation_steps 1 \
--seed 42 --encoder_lr_scale 1.0 --train_split_portion 0.9 \
--output_dir /logs/clevrtex/nolsd_256_saved \
--backbone_config /configs/clevrtex/backbone/config.json \
--slot_attn_config /configs/clevrtex/slot_attn/config.json \
--unet_config /configs/clevrtex/unet_uncond/config.json \
--scheduler_config /configs/clevrtex/scheduler/scheduler_config.json \
--dataset_root /clevrtexv2_full/images/ \
--dataset_glob '*.png' --train_batch_size 32 --resolution 256 --validation_steps 5000 \
--tracker_project_name latent_slot_diffusion \
--tracker_experiment_name clevrtex_noslots_fixed \
--allow_tf32