#!/bin/bash

# Activate conda environment - adjust path as needed
source ~/miniconda3/etc/profile.d/conda.sh
conda activate lsd  # replace 'lsd' with your environment name

# Run the training script with regular Python
CUDA_VISIBLE_DEVICES=3 accelerate launch train_lsd.py \
--dataloader_num_workers 8 --learning_rate 1e-4 \
--mixed_precision bf16 --num_validation_images 32 --val_batch_size 32 --max_train_steps 300000 \
--checkpointing_steps 25000 --checkpoints_total_limit 2 --gradient_accumulation_steps 1 \
--seed 42 --encoder_lr_scale 1.0 --train_split_portion 0.9 \
--backbone_config /configs/faces/backbone/config.json \
--slot_attn_config /configs/faces/slot_attn/config2.json \
--unet_config /configs/faces/unet/config.json \
--scheduler_config /configs/faces/scheduler/scheduler_config.json \
--dataset_root /faces_data/ \
--train_batch_size 64 --resolution 256 --validation_steps 5000 \
--tracker_project_name latent_slot_diffusion \
--tracker_experiment_name faces_lsd_4slots_noceleba \
--output_dir /logs/faces/4slots_trullyjoint \
--dataset_glob '**/*.png **/*.jpg' \
--use_slot_conditioning \
--allow_tf32