Due to the upload file size limit, we haven't included all pretrained backbones but have provided their configuration files; the included data covers concepts for the FMNIST dataset, graphs for all datasets, and mutually exclusive concepts. 

# How to run
1. Install the packages and dependencies found in `requirements.txt`.
2. Download and save the datasets under `./data`.
3. Run the script: `python generate_grid_hypertune.py --config <path_to_yaml_file>` on whichever yaml configuration file. This will generate all different hyperparameter + seed combinations found in that configuration, and will save them in `generated_yamls`. You can find the configurations after model selection in `./yaml_configs/best_configs`, and for the C --> Y baselines in `./yaml_configs/c2y_configs`.
3. Run the script: `python simple_main.py --config <path_to_yaml_file>`. Make sure that the config file is one of the generated ones.
4. To get the correlation matrices of the exogenous variables, we store the output of the representation splitter (`seedX_trainY_exogenous.csv`) and the output of the concepts+side channel (`seedX_trainY_C_and_S.csv`), for each experiment individually. In the same folder, we also store the 5th and 95th percentiles used in interventions. They can be found in `experiments/.../version_0` after running an experiment.  

# Creating your own backbones

The checkpoints of the backbones used in our experiments are found in `./pretrained_models`. We also provide some configurations that create it from scratch in `./yaml_configs/backbones`.    
