#!/usr/bin/bash
SNAPSHOTS=snapshots/imagenet100/vits_fps_attn_groupsep8_T0.03_w0.0_graph_0.0_ep200_seeds_v2_pos_ii
mkdir -p ${SNAPSHOTS}
mkdir -p ${SNAPSHOTS}/lincls_bs256_lr0.8

python -W ignore main_moco_seg.py \
    -a vit_conv_small -b 256 \
    --optimizer=adamw --lr=1.5e-4 --weight-decay=.1 \
    --epochs=200 --warmup-epochs=20 \
    --stop-grad-conv1 --moco-m-cos --moco-t=.2 \
    --dist-url 'tcp://localhost:10001' \
    --multiprocessing-distributed --world-size 1 --rank 0 \
    ./data/ILSVRC2014/Img-100/
mv checkpoint_0199.pth.tar ${SNAPSHOTS}

python -W ignore main_lincls_seg.py \
    -a vit_conv_small --lr 0.8 -b 256 \
    --dist-url 'tcp://localhost:10002' \
    --multiprocessing-distributed --world-size 1 --rank 0 \
    --pretrained ${SNAPSHOTS}/checkpoint_0199.pth.tar \
    ./data/ILSVRC2014/Img-100/ &> lincls_log
mv checkpoint.pth.tar model_best.pth.tar lincls_log ${SNAPSHOTS}/lincls_bs256_lr0.8
