#!/usr/bin/bash
SNAPSHOTS=snapshots/imagenet1k/cast_soft_bs256_epo100
mkdir -p ${SNAPSHOTS}
mkdir -p ${SNAPSHOTS}/lincls

python -W ignore main_moco_seg.py \
    -a vit_conv_small -b 256 \
    --optimizer=adamw --lr=1.5e-4 --weight-decay=.1 \
    --epochs=100 --warmup-epochs=10 \
    --stop-grad-conv1 --moco-m-cos --moco-t=.2 \
    --dist-url 'tcp://localhost:10001' \
    --multiprocessing-distributed --world-size 1 --rank 0 \
    ./data/ILSVRC2014/Img/
mv checkpoint_0099.pth.tar ${SNAPSHOTS}

python -W ignore main_lincls_seg.py \
    -a vit_conv_small --lr 30 -b 1024 \
    --dist-url 'tcp://localhost:10002' \
    --multiprocessing-distributed --world-size 1 --rank 0 \
    --pretrained ${SNAPSHOTS}/checkpoint_0099.pth.tar \
    ./data/ILSVRC2014/Img/ &> lincls_log
mv checkpoint.pth.tar model_best.pth.tar lincls_log ${SNAPSHOTS}/lincls
