# A Simple yet Powerful Deep Active Learning with Snapshots Ensembles

Official Implementation of the paper "A Simple yet Powerful Deep Active Learning with Snapshots Ensembles"

---


# How to Use

## How to Run

Run experiments on CIFAR-10 dataset with ResNet-18. Specify an acquisition function with `--query_type` and acquisition size with `--query_size` argument.

```bash
python scripts/train_snapshot.py -f configs/cifar10_resnet18.json --query_type ensvr

python scripts/train_ensemble.py -f configs/cifar10_resnet18.json --query_type ensvr

python scripts/train_snapshot_finetuning.py -f configs/cifar10_resnet18.json --query_type ensvr
```

Run experiments on CIFAR-100 dataset with ResNet-18. Specify an acquisition function with `--query_type` and acquisition size with `--query_size` argument.

```bash
python scripts/train_snapshot.py -f configs/cifar100_resnet18.json --query_type ensvr

python scripts/train_ensemble.py -f configs/cifar100_resnet18.json --query_type ensvr

python scripts/train_snapshot_finetuning.py -f configs/cifar100_resnet18.json --query_type ensvr
```

Run experiments on Tiny-ImageNet-200 dataset with pretrained ResNet-50. Specify an acquisition function with `--query_type` and acquisition size with `--query_size` argument.

```bash
python scripts/train_snapshot.py -f configs/tiny224_resnet50.json --query_type ensvr

python scripts/train_ensemble.py -f configs/tiny224_resnet50.json --query_type ensvr

python scripts/train_snapshot_finetuning.py -f configs/tiny224_resnet50.json --query_type ensvr
```

## Download Datasets

CIFAR10 and CIFAR100 dataset will be downloaded using torchvision and saved to a directory provided as `--dataset_path`.

However, for Tiny Imagenet, you will need to download it first, unzip it, and specify a unzipped directory as `--dataset_path`. 

Our code will automatically create a file structure for the validation set.

Please edit config files according to your local setting before running the scripts. 

## Edit Configurations

Configuration files are in `./cifar/configs` and `./tiny-imagenet/configs` folder. You can directly edit these files for different hyperparameters. 


---
