from .random import RandomSampling, LabeledRandomSampling
from .lc import LeastConfidentSampling
from .entropy import EntropySampling

from .ensvr import EnsembleVariationRatio
from .ensvoteentropy import EnsembleVoteEntropy
from .ensbald import EnsembleBALD
from .ensmaxentropy import EnsembleMaxEntropy

from .mcbald import MCBald
from .mcentropy import MCMaxEntropy
from .mcvr import MCVariationRatio

NAME_TO_CLS = {
    "random": RandomSampling,
    "ensvr": EnsembleVariationRatio,
    "ensvoteentropy": EnsembleVoteEntropy,
    "ensbald": EnsembleBALD,
    "ensmaxentropy": EnsembleMaxEntropy,
    "lc": LeastConfidentSampling,
    "entropy": EntropySampling,
    "mcbald": MCBald,
    "mcmaxentropy": MCMaxEntropy,
    "mcvr": MCVariationRatio
}

ALL_METHODS = list(NAME_TO_CLS.keys())