# Some functions

# Custom function to process each row
fill_na <- function(row, number) {
  len <- length(row)
  # Step 1: Fill NA from left with 1 until a non-NA value is found
  for (i in 1:len) {
    if (is.na(row[i])) {
      row[i] <- number
      break
    }
  }
  # Step 2: For remaining NAs, fill with value to the left
  for (i in 2:len) {
    if (is.na(row[i])) {
      row[i] <- row[i-1]
    }
  }
  return(row)
}

relu <- function(x) {
  return(ifelse(x > 0, x, 0))
}

truncate <- function(x, upper){
  return(ifelse(x < upper, x, upper))
}

is_unique <- function(uM, uW){
  match1 = galeShapley.marriageMarket(uM, uW)
  match2 = galeShapley.marriageMarket(uW, uM)
  if (all(match1$proposals == match2$engagements) == TRUE){
    return(TRUE)
  }
  else{
    return(FALSE)
  }
}

generateSpecialMatrix <- function(rows, cols) {
  # Generate a random matrix of size rows x cols
  matrix <- matrix(runif(rows * cols), nrow=rows)
  
  for(j in 1:cols) {
    if (j <= rows) {
      # Get the index of the largest value from the elements below the (j-1)th position
      idx <- which.max(matrix[j:rows, j]) + j - 1
      
      # Swap the jth element with the largest value
      tmp <- matrix[j, j]
      matrix[j, j] <- matrix[idx, j]
      matrix[idx, j] <- tmp
    }
  }
  
  return(matrix)
}

generate_spc <- function(n){
  uM = matrix(nrow = n, ncol = n)
  uW = matrix(nrow = n, ncol = n)
  for (i in 1:n) {
    for(j in 1:i){
      uM[j, i] <- runif(1, min = 0, max = 1)
      uW[j, i] <- runif(1, min = 0, max = 1)
    }}
  for (i in 1:(n-1)){
    for (j in (i+1):n){
      uM[j, i] <- runif(1, min = 0, max = uM[i, i])
      uW[j, i] <- runif(1, min = 0, max = uW[i, i])
    } 
  }
  for(i in 1:n){
    uM[,i] = (sapply(uM[,i], function(x) sum(uM[,i] < x)) + 1)
    uW[,i] = (sapply(uW[,i], function(x) sum(uW[,i] < x)) + 1)
  }
  return(list(uM = uM, uW = uW))
}

is_stable <- function(men_pref, women_pref, matching){
  n <- ncol(men_pref)
  
  for (man in 1:n){
    woman <- matching[man]
    women_better_than_current <- which(men_pref[,man] > men_pref[woman, man])
    if (length(women_better_than_current) > 0){
      for (ii in women_better_than_current){
        man_pair = which(matching == ii)
        if (women_pref[man_pair, ii] < women_pref[man, ii]){
          return(FALSE)
        }
      }
    }
    
  }
  return(TRUE)
}

# Custom function to process each row
fill_na <- function(row) {
  len <- length(row)
  # Step 1: Fill NA from left with 1 until a non-NA value is found
  # Step 2: For remaining NAs, fill with value to the left
  for (i in 1:len) {
    if (is.na(row[i])) {
      row[i] <- row[i-1]
    }
  }
  return(row)
}

# packages
#install.packages("matchingR")
library(Rcpp)
library(matchingR)
#install.packages("ggplot2")
library(ggplot2)
