% grad_p_slack  Compute gradient of p_slack with respect to decision variables x_cur
function dp_slack_dx = grad_p_slack(Vm, Va, V_slack, Ybus, ...
    idx_slack, idx_nonslack, n_nonslack, idx_var)
    % Compute power flow derivatives
    [dS0_dSbus, ~] = pf_derivatives(Vm, Va, V_slack, Ybus, ...
        idx_slack, idx_nonslack, n_nonslack);

    % Extract real components to get active power derivatives
    grad_matrix = real(dS0_dSbus(idx_var));

    % Format output as column vector matching decision variable dimension
    dp_slack_dx = grad_matrix(:);
end