function [dS0_dSbus, dVm_dSbus] = pf_derivatives(Vm, Va, V0, Ybus, ...
    idx_slack, idx_nonslack, n_nonslack)

V_phasor = Vm .* exp(1j * Va);

[dSbus_dVa, dSbus_dVm] = dSbus_dV(Ybus, V_phasor, 0);

dp_dVa = real(dSbus_dVa(idx_nonslack, idx_nonslack));
dp_dVm = real(dSbus_dVm(idx_nonslack, idx_nonslack));
dq_dVa = imag(dSbus_dVa(idx_nonslack, idx_nonslack));
dq_dVm = imag(dSbus_dVm(idx_nonslack, idx_nonslack));
J = [dp_dVm, dp_dVa; dq_dVm, dq_dVa];

dV_dSbus = full(inv(J));
dVm_dSbus = dV_dSbus(1:n_nonslack, :);
dVa_dSbus = dV_dSbus(n_nonslack+1:end, :);

dS0_dSbus = V0 * conj(Ybus(idx_slack,idx_nonslack)) * ...
    (diag(exp(-1j * Va(idx_nonslack))) * dVm_dSbus - 1j * diag(conj(V_phasor(idx_nonslack))) * dVa_dSbus);
end