function [V_phasor, S0] = pf_radial(p_bus, q_bus, V0, Mat_pf_back, Mat_pf_forward, branch_z, ...
    idx_slack, n_bus)

eps = 1e-9;
V_vec_old = zeros(n_bus, 1);
V_vec = V0 * ones(n_bus, 1);
delta = norm(V_vec_old - V_vec, 'Inf');

while delta >= eps
    V_vec_old = V_vec;
    I_inj_vec = conj(-(p_bus + 1j * q_bus) ./ V_vec);
    I_flow_vec = Mat_pf_back \ I_inj_vec;
    
    tmp = branch_z .* I_flow_vec;
    tmp(idx_slack) = V0;
    V_vec = Mat_pf_forward \ tmp;
    
    delta = norm(V_vec_old - V_vec, 'Inf');
end

V_phasor = V_vec;
I_inj_vec = conj(-(p_bus + 1j * q_bus) ./ V_vec);
I_flow_vec = Mat_pf_back \ I_inj_vec;
S0 = - V0 * I_flow_vec(idx_slack);
end