function [g] = grad_phi(Vm, Va, p0, D, dev_alpha, pen_alpha, Vm_lb, Vm_ub, V0, Ybus, ...
    idx_slack, idx_nonslack, n_nonslack, idx_var)

[dS0_dSbus, dVm_dSbus] = pf_derivatives(Vm, Va, V0, Ybus, ...
    idx_slack, idx_nonslack, n_nonslack);


Vm_ub_violation = (Vm - Vm_ub) .* (Vm - Vm_ub > 0);
Vm_lb_violation = (Vm_lb - Vm) .* (Vm_lb - Vm > 0);
g = 2 * dev_alpha * (p0 - D) * real(dS0_dSbus(idx_var)) ...
    + 2 * pen_alpha * sum(diag(Vm_ub_violation(idx_nonslack)) * dVm_dSbus(:, idx_var), 1) ...
    - 2 * pen_alpha * sum(diag(Vm_lb_violation(idx_nonslack)) * dVm_dSbus(:, idx_var), 1);

g = -g';
end