%% ZOB-GDA: Zeroth-Order Block Gradient Descent-Ascent Algorithm
% This code implements a zeroth-order block gradient descent-ascent algorithm
% with block coordinate updates


preprocess; 
%% Algorithm 
n_trial = 50;               % Number of independent trials
T = 20000;                  % Number of iterations

% Initialize recording matrices
fvals = zeros(T, n_trial) ;
lvals = zeros(T, n_trial);
gnorms = zeros(T, n_trial);
consv = zeros(T, n_trial) ;

rk = repmat(min(1e-1./((1:T).^1.2)', 2e-4), 1, n_trial);            % Smoothing radius
alpha = 0.03;                                                       % Stepsize for primal update
beta = 0.01*alpha;                                                  % Stepsize for dual update
b = 1;                                                              % Block size

x0 = [res_pf_original.bus(idx_load_p, 3); res_pf_original.bus(idx_load_q, 4)] / baseMVA;

%% Main Optimization Loop (Parallel Trials)
parfor pp = 1:n_trial
    %%% Initialize variables for current trial
    rng(pp); 
    x_cur= x0*pp/n_trial;
    stationarity=zeros(dim+1, 1);
    p_bus = zeros(n_bus, 1);
    q_bus = zeros(n_bus, 1);
    p_bus_pert = zeros(n_bus, 1);
    q_bus_pert = zeros(n_bus, 1);
    p_plus_bus = zeros(n_bus, 1);
    q_plus_bus = zeros(n_bus, 1);
    p_bus_plus_pert = zeros(n_bus, 1);
    q_bus_plus_pert = zeros(n_bus, 1);
    lambd = 0;
    
    for k = 1:T
        %%% Evaluate Current Point
        p_bus(idx_load_p) = x_cur(1:dim_real);
        q_bus(idx_load_p) = x_cur(dim_real+1:end);
        [V_phasor, S_slack] = pf_radial(p_bus, q_bus, V_slack, Mat_pf_back, Mat_pf_forward, branch_z, ...
            idx_slack, n_bus);
        Vm = abs(V_phasor);
        Va = angle(V_phasor);
        p_slack = real(S_slack);

        phi_cur = global_obj(p_slack, Vm, p_desired, Vm_lb, Vm_ub, dev_alpha, pen_alpha);
        localf_cur = sum(local_a .* (x_cur-x_nom).^2 + local_b .* (x_nom-x_cur));
        f_cur = phi_cur + localf_cur;

        %%% Metrics Calculation
        fvals(k, pp) = f_cur;                                                       % Objective value record
        grad_x = grad_phi(Vm, Va, p_slack, p_desired, dev_alpha, pen_alpha, Vm_lb, Vm_ub, V_slack, Ybus, ...
            idx_slack, idx_nonslack, n_nonslack, idx_var) + ...
            2 * local_a .* (x_cur - x_nom) - local_b + ...
            lambd*grad_p_slack(Vm, Va, V_slack, Ybus,idx_slack, idx_nonslack, n_nonslack, idx_var);
        grad_y = p_slack-p_desired;
        stationarity(1:dim)=(x_cur-max(min(x_cur-alpha*grad_x, x_ub), x_lb))/alpha;
        stationarity(dim+1)=(lambd-max(lambd+beta*grad_y,0))/beta;
        gnorms(k, pp) = norm(stationarity);                                         % Stationarity measure record
        lvals(k, pp) = lambd;                                                       % Dual variable record
        cons_error=max(p_slack-p_desired, 0);
        consv(k,pp)=norm(cons_error) ;                                              % Constraint violation
        
        %%% Block Coordinate Update for Primal Variable
        x_next = x_cur;
        idx_list = randperm(dim, b); 
        for j =1:b
            idx_pert = idx_list(j)
            r_cur = min(rk(k, pp), (x_ub(idx_pert) - x_lb(idx_pert))/2);
            if x_cur(idx_pert) + r_cur > x_ub(idx_pert)
                dir_pert = -1;
            elseif x_cur(idx_pert) - r_cur < x_ub(idx_pert)
                dir_pert = 1;
            else
                dir_pert = randi(2) * 2 - 3;
            end
    
            x_pert = x_cur;
            x_pert(idx_pert) = x_pert(idx_pert) + r_cur * dir_pert;

            % Evaluate perturbed point
            p_bus_pert(idx_load_p) = x_pert(1:dim_real);
            q_bus_pert(idx_load_p) = x_pert(dim_real+1:end);
            [V_phasor_pert, S_slack_pert] = pf_radial(p_bus_pert, q_bus_pert, V_slack, Mat_pf_back, Mat_pf_forward, branch_z, ...
                idx_slack, n_bus);
            Vm_pert = abs(V_phasor_pert);
            Va_pert = angle(V_phasor_pert);
            p_slack_pert = real(S_slack_pert);
            phi_pert = global_obj(p_slack_pert, Vm_pert, p_desired, Vm_lb, Vm_ub, dev_alpha, pen_alpha);
            
            % Coordinate update
            x_next(idx_pert) = x_cur(idx_pert) - alpha * ...
            (2 * local_a(idx_pert) * (x_cur(idx_pert) - x_nom(idx_pert)) - local_b(idx_pert) ...
            + (phi_pert - phi_cur) / r_cur * dir_pert+ lambd*(p_slack_pert - p_slack) / r_cur * dir_pert);% constraint
            x_next(idx_pert) = max(min(x_next(idx_pert), x_ub(idx_pert)), x_lb(idx_pert));
        end
        %%%  Dual Variable Update
        lambd=max(lambd + beta*(p_slack-p_desired),0);
        x_cur=x_next;

    end 
end

save res_ZOBGDA_tau1_50times.mat; 

