## Install Dependencies

```bash
sudo apt install -y xvfb
conda create -n mcu python=3.9.16 -y 
conda activate mcu 
conda install --channel=conda-forge openjdk=8 gym=0.19 -y 
pip install git+https://github.com/MineDojo/MineCLIP
pip install -e .
```

Then, run the simulator.
```bash
cd mcu/stark_tech
xvfb-run -a python env_interface.py
```

If you see the following logs, then the simulator is successfully installed. 

```
[Close-ended] Slow reset with world seed:  19961103
Dict('buttons': MultiDiscrete([8641]), 'camera': MultiDiscrete([121]))
dict_keys(['pov', 'inventory', 'equipped_items', 'pickup', 'break_item', 'craft_item', 'mine_block', 'kill_entity', 'player_pos', 'is_gui_open'])
```

For task generation:
```bash
cd task_generation/
python generate_configs.py
```


To run inference:
```bash
cd mcu/
xvfb-run -a python inference.py --test 'run_agent' #run un-conditioned agent
xvfb-run -a python inference.py --test 'run_agent_video' #run agent with video instruction
xvfb-run -a python inference.py --test 'run_agent_text' #run agent with text instruction
```


For automatic evaluation:

```bash
#Compare two videos
python video_comparison.py --video_path_a='xxx/xxx.mp4' --video_path_b='xxx/xxx.mp4' --criteria_path='xxx/xxx.txt' 
#Individual video evaluation
python individual_video_rating.py --video_path='xxx/xxx/' --criteria_path='xxx/xxx/' 
#Batch video evaluation
python batch_video_rating.py --videos_path='xxx/xxx/' --criteria_files_path='xxx/xxx/' 
```

## videos_path structure
```
videos_path     
├── build_waterfall # task_name_1     
│     ├── xxx.mp4
│     ├── xxx.mp4
├── build_house # task_name_2
│     ├── xxx.mp4
│     ├── xxx.mp4
├── xxx # task_name_3
│     ├── xxx.mp4
│     ├── xxx.mp4
```
## criteria_files_path structure
```
criteria_files_path     
├── build_waterfall.txt # task_name_1     
├── build_house.txt # task_name_2
├── xxx.txt # task_name_3
```

