import glob
import importlib.util
import os
import shutil
import sys

def backup_python_files(src, dest, exclude_dirs=[]):
    """
    Recursively copies all Python files in src to dest. If dest or any subdirectory does not exist, they are created. This has saved my life quite a few times.
    """
    for file_path in glob.glob(os.path.join(src, '**', '*.py'), recursive=True):
        if "/code_backup/" in file_path:
            continue
        if any([file_path.startswith(dir) for dir in exclude_dirs]):
            continue
        new_path = f"{dest}/{file_path.replace('./', '')}"
        dirname = os.path.dirname(new_path)
        if not os.path.exists(dirname):
            os.makedirs(dirname)
        shutil.copy(file_path, new_path)

def import_class_from_path(class_name, file_path):
    """
    Import a class from a file path
    """
    # # get directory of the file and its parent
    # directory = os.path.dirname(file_path)
    # # add parent directory to sys.path
    # if directory not in sys.path:
    #     sys.path.insert(0, directory)
    #     print(f"Added {directory} to sys.path")
    # Get the current working directory
    parent_dir = os.path.dirname(file_path)

    # # Add the parent directory to sys.path
    # if parent_dir not in sys.path:
    #     sys.path.insert(0, parent_dir)
    #     print(f"Added {parent_dir} to sys.path")
    sys_path_backup = sys.path.copy()
    # this is to prevent imports from everything that is not conda or the parent directory
    for dir in sys.path:
        if not dir.startswith("/opt/conda"):
            sys.path.remove(dir)
    sys.path = [parent_dir] + sys.path
    # import from path
    spec = importlib.util.spec_from_file_location(class_name, file_path)
    module = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(module)
    # get the class from the module
    cls = getattr(module, class_name)
    # remove the directory from sys.path
    sys.path = sys_path_backup
    return cls

def try_load_model_from_backup_file(model_ckpt, backup_file=None, model_class_name="MyModel"):
    if backup_file is None:
        backup_file = model_ckpt.split("checkpoints")[0] + "code_backup/train.py"
    try:
        ModelClass = import_class_from_path(model_class_name, backup_file)
        model = ModelClass.load_from_checkpoint(model_ckpt)
        return model
    except Exception as e:
        print(f"Could not load model from backup file: {e}")
        return None