import numpy as np
import tqdm

def get_best_case_iou(pred_locmap, gt_locmap, n_threshs=20, min_thresh=None, max_thresh=None):
    if min_thresh is None:
        min_thresh = pred_locmap.min()
    if max_thresh is None:
        max_thresh = pred_locmap.max()
    threshs = np.linspace(min_thresh, max_thresh, n_threshs)
    best_iou = 0
    best_thresh = 0
    pbar = tqdm.tqdm(total=n_threshs, desc="Best IOU = ???", position=0)
    for thresh in threshs:
        pred_locmap_thr = pred_locmap > thresh
        intersection = np.logical_and(pred_locmap_thr, gt_locmap).sum()
        union = np.logical_or(pred_locmap_thr, gt_locmap).sum()
        iou = intersection / union
        if iou > best_iou:
            best_iou = iou
            best_thresh = thresh
            pbar.set_description(f"Best IOU = {best_iou:.2f}")
        pbar.update(1)

    return best_iou, best_thresh