import glob
import os

device = "cuda:0"    
out_dir = "./eval/tomotwin_runs"  # where to save results

subtomo_size = 64
subtomo_overlap = 32
batch_size = 64

save_pred_locmap_dicts = True

# runs eval for all these models
model_ckpts = [
    "./propicker.ckpt"
]
# this is to load model from older versions of the code base, not important for most users
backup_files = [None]

# map model_ckpt to name, resuls for each model_ckpt will be saved in f"out_dir/{model_ckpt_to_name_fn(model_ckpt)}"
def model_ckpt_to_name_fn(ckpt):
    return os.path.splitext(ckpt)[0]

runs = [
    "tomo_simulation_round_1/tomo_08.2022-04-11T191718+0200",
    "tomo_simulation_round_2/tomo_08.2022-05-10T200254+0200",
    "tomo_simulation_round_3/tomo_08.2022-04-12T130359+0200",
    "tomo_simulation_round_4/tomo_08.2022-05-12T135012+0200",
    "tomo_simulation_round_5/tomo_08.2022-05-11T134419+0200",
    "tomo_simulation_round_6/tomo_08.2022-04-12T211730+0200",
    "tomo_simulation_round_7/tomo_08.2022-05-12T140747+0200",
    "tomo_simulation_round_8/tomo_08.2022-05-12T121323+0200",
    "tomo_simulation_round_9/tomo_08.2022-04-12T212347+0200",
    "tomo_simulation_round_10/tomo_08.2022-05-03T213239+0200",
    "tomo_simulation_round_11/tomo_08.2022-05-04T132658+0200",
    "tomo_simulation_round_demo/tomo_01",
]

limit_to_pdbs = None

metric_of_interest = "F1"  # which metric to optimize hyperparameters (thresh, size) for
get_best_case_cluster_based_picking_performance_args = {
    "optimize_thresh": True,
    "n_thresh_steps": 10,  # tries 10 thesholds between predicted locmaps min and max
    "n_size_steps": 5,  # how many cluster sizes to try between minimum cluster size and the 0.45 quantile of all cluster sizes; similar for max cluster size
    "iou_thresh": 0.6,  # iou threshold for matching a cluster centroid to a ground truth position, TomoTwin uses 0.6 
    "metric": metric_of_interest,
}
compute_tomotwin_picking_performance = False