
## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

## Training

To train VICReg for 100 epochs on a single node with 8 gpus, run:

```
python main_vicreg.py --data-dir /path/to/imagenet/ --epochs 100 --batch-size 2048 --base-lr 0.3 
```

## Evaluation

To evaluate a pretrained model on linear classification on ImageNet, run:

```
python eval.py /path/to/imagenet/ /path/to/checkpoint/resnet50.pth --lr-head 0.02 --checkpoint-dir ./checkpoint/linear/
```

To evaluate a pretrained model on semi-supervised classification on ImageNet, run:

```
python evaluate.py /path/to/imagenet/ /path/to/checkpoint/resnet50.pth --weights finetune --train-perc 1 --epochs 20 --lr-backbone 0.03 --lr-classifier 0.08 --weight-decay 0 --checkpoint-dir ./checkpoint/semisup/
```
