## Install
This code was developed for Python 3.7.5, and is most likely easiest to reproduce using [virtualenvwrapper](https://virtualenvwrapper.readthedocs.io/en/latest/). After setting up the virtual environmnet, simply run the `setup.sh` script. 

Reproducing the convex combination experiments in Appendix C requires a working MOSEK install and license as documented [here](https://docs.mosek.com/latest/install/installation.html) -- this license is freely available for academic researchers. A latex installation is also recommended for reproducing the final plots.

## Data
The [Kaggle cats-dogs](https://www.kaggle.com/c/dogs-vs-cats-redux-kernels-edition) and [Malimg](https://www.dropbox.com/s/ep8qjakfwh1rzk4/malimg_dataset.zip?dl=0) datasets should be downloaded and placed in the `/data` directory. MNIST and CIFAR-10 datasets are downloaded automatically upon running.

## Execution
To reproduce the main experiments of the paper, change to the `convexrobust/main` directory and run `python main.py --data=mnist_38 --train --eval`, where the `data` option is one of `mnist_38`, `malimg`, `cifar10_catsdogs`, or `kaggle_catsdogs`. Output figures should lie in `convexrobust/main/figs/`.

To reproduce the convex combination experiments, enter the `misc_scripts` directory and execute `reconstruction_main.py` and `reconstruction_plot.py`.

## Key implementations
The base class for all convexly certified methods lies in `convexrobust/model/convex_certifiable.py`, with specific subclass instantiations lying in `convexrobust/model/insts/convex.py`. The file `convexrobust/model/modules.py` contains implementations of ICNN MLPs and convnets.
