#!/bin/bash
#SBATCH --job-name=task1 # Job name
#SBATCH --nodes=1 # Run on a single node
#SBATCH --ntasks-per-node=1
#SBATCH --partition=ai # Run in ai queue
#SBATCH --qos=ai 
#SBATCH --account=ai 
#SBATCH --gres=gpu:tesla_v100:1 
#SBATCH --mem=50G 
#SBATCH --time=7-0:0:0 # Time limit days-hours:minutes:seconds
#SBATCH --output=test-%j.out # Standard output and error log


echo "Setting stack size to unlimited..."
ulimit -s unlimited
ulimit -l unlimited
ulimit -a
echo

source /xxxxx/bin/activate erbrd


nvidia-smi

#python lc_mnist.py --logger_name 11 --n_epochs 101 --method "bp" --lr 0.00005
#python lc_mnist.py --logger_name 12 --n_epochs 101 --method "bp" --lr 0.00005
#python lc_mnist.py --logger_name 13 --n_epochs 101 --method "bp" --lr 0.00005
#python lc_mnist.py --logger_name 14 --n_epochs 101 --method "bp" --lr 0.00005
#python lc_mnist.py --logger_name 15 --n_epochs 101 --method "bp" --lr 0.00005

#python lc_mnist.py --logger_name 11 --n_epochs 101 --method "dfa1"
#python lc_mnist.py --logger_name 12 --n_epochs 101 --method "dfa1"
#python lc_mnist.py --logger_name 13 --n_epochs 101 --method "dfa1"
#python lc_mnist.py --logger_name 14 --n_epochs 101 --method "dfa1"
#python lc_mnist.py --logger_name 15 --n_epochs 101 --method "dfa1"

#python lc_mnist.py --logger_name 11 --n_epochs 101 --method "dfa2"
#python lc_mnist.py --logger_name 12 --n_epochs 101 --method "dfa2"
#python lc_mnist.py --logger_name 13 --n_epochs 101 --method "dfa2"
#python lc_mnist.py --logger_name 14 --n_epochs 101 --method "dfa2"
#python lc_mnist.py --logger_name 15 --n_epochs 101 --method "dfa2"

python lc_mnist.py --logger_name 11 --n_epochs 101 
python lc_mnist.py --logger_name 12 --n_epochs 101 
python lc_mnist.py --logger_name 13 --n_epochs 101 
python lc_mnist.py --logger_name 14 --n_epochs 101 
python lc_mnist.py --logger_name 15 --n_epochs 101


source deactivate
