#SBATCH --job-name=x
#SBATCH --nodes 1
#SBATCH --ntasks-per-node=2
## SBATCH --partition=mid
#SBATCH --partition=ai
#SBATCH --account=ai
#SBATCH --mem=40G
#SBATCH --gres=gpu:1
#SBATCH --constraint=tesla_v100
#SBATCH --time=7-0
#SBATCH --output=x-%J.log

# Please read before you run: http://login.kuacc.ku.edu.tr/#h.3qapvarv2g49

################################################################################
##################### !!! DO NOT EDIT BELOW THIS LINE !!! ######################
################################################################################

# Load Anaconda
#echo "======================="
#echo "Loading Anaconda Module..."
#module load anaconda/3.6
#module load cuda/11.0  
#module load cudnn/8.0.4/cuda-11.0
#echo "======================="

#source activate atepython
eval "$(micromamba shell hook --shell bash )"

micromamba activate
micromamba activate mm_pytorch

echo
echo "============================== ENVIRONMENT VARIABLES ==============================="
env
echo "===================================================================================="
echo
echo

# Set stack size to unlimited
echo "Setting stack size to unlimited..."
ulimit -s unlimited
ulimit -l unlimited
ulimit -a
echo

################################################################################
##################### !!! DO NOT EDIT ABOVE THIS LINE !!! ######################
################################################################################

# get tunneling info
XDG_RUNTIME_DIR=""
port=$(shuf -i 6000-6999 -n1)
node=$(hostname -s)
user=$(whoami)


# CIFAR 10
python3 CIM_EBD_CIFAR10.py  --pickle_name_for_results "CIFAR10Test.pkl" --train_start 0 0 0 0 0 0 0 0 0 0 0 --br_update_lateralv 0.03 --br_update_lateralv_cont 0.03 --act_l1_lr_ffv 0.01575 0.01575 0.01575 0.01575 0.0175 0.01575 0.01575 0.00575 0.00675 0  --layer_pow_targetv 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0  0.1 --momentum_ffv 0.99996 --neural_dynamic_iterations_free_list 15 --lr_erv 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 60000  --lr_weight_l1vv 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 --lr_weight_bb_l2v 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 --seed_list 144 145 --weight_prune_period 5000 --weight_prune_scale 0.00003



# MNIST
python3 CIM_EBD_MNIST.py  --pickle_name_for_results "MNISTTest10Layer.pkl" --architecture 784 2000 500 500 500 500 500 500 500 500 10 --train_start 0 0 0 0 0 0 0 0 0 0 0 --br_update_lateralv 0.03 --br_update_lateralv_cont 0.03 --act_l1_lr_ffv 0.01575 0.01575 0.01575 0.01575 0.0175 0.01575 0.01575 0.00575 0.00675 0  --layer_pow_targetv 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 2.0  0.1 --momentum_ffv 0.99996 --neural_dynamic_iterations_free_list 15 --lr_erv 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 3.5 60000  --lr_weight_l1vv 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 --lr_weight_bb_l2v 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 5e-4 --seed_list 144 145 --weight_prune_period 50 --weight_prune_scale 0.0002


