#!/bin/bash

#SBATCH --job-name=x
#SBATCH --nodes 1
#SBATCH --ntasks-per-node=2
#SBATCH --partition=ai
#SBATCH --account=ai
#SBATCH --mem=40G
#SBATCH --gres=gpu:1
#SBATCH --constraint=tesla_v100
#SBATCH --time=7-0
#SBATCH --output=x-%J.log


# Please read before you 

################################################################################
##################### !!! DO NOT EDIT BELOW THIS LINE !!! ######################
################################################################################

# Load Anaconda
#echo "======================="
#echo "Loading Anaconda Module..."
#module load anaconda/3.6
#module load cuda/11.0  
#module load cudnn/8.0.4/cuda-11.0
#echo "======================="

#source activate atepython
eval "$(micromamba shell hook --shell bash )"

micromamba activate
micromamba activate mm_pytorch

echo
echo "============================== ENVIRONMENT VARIABLES ==============================="
env
echo "===================================================================================="
echo
echo

# Set stack size to unlimited
echo "Setting stack size to unlimited..."
ulimit -s unlimited
ulimit -l unlimited
ulimit -a
echo

################################################################################
##################### !!! DO NOT EDIT ABOVE THIS LINE !!! ######################
################################################################################

# get tunneling info
XDG_RUNTIME_DIR=""
port=$(shuf -i 6000-6999 -n1)
node=$(hostname -s)
user=$(whoami)

# 104 
CIM_EBD_3Layer_CIFAR10.py

source deactivate
