#!/bin/bash
#SBATCH --job-name=task1 # Job name
#SBATCH --nodes=1 # Run on a single node
#SBATCH --ntasks-per-node=1
#SBATCH --partition=ai # Run in ai queue
#SBATCH --qos=ai 
#SBATCH --account=ai 
#SBATCH --gres=gpu:tesla_v100:1 
#SBATCH --mem=50G 
#SBATCH --time=7-0:0:0 # Time limit days-hours:minutes:seconds
#SBATCH --output=test-%j.out # Standard output and error log


echo "Setting stack size to unlimited..."
ulimit -s unlimited
ulimit -l unlimited
ulimit -a
echo

source /xxxxx/bin/activate erbrd

nvidia-smi

python mlp_cifar.py --logger_name 1
python mlp_cifar.py --logger_name 2
python mlp_cifar.py --logger_name 3
python mlp_cifar.py --logger_name 4
python mlp_cifar.py --logger_name 5

python mlp_mnist.py --logger_name 1
python mlp_mnist.py --logger_name 2
python mlp_mnist.py --logger_name 3
python mlp_mnist.py --logger_name 4
python mlp_mnist.py --logger_name 5

source deactivate
