#!/bin/bash
#SBATCH --job-name=task1 # Job name
#SBATCH --nodes=1 # Run on a single node
#SBATCH --ntasks-per-node=1
#SBATCH --partition=ai # Run in ai queue
#SBATCH --qos=ai 
#SBATCH --account=ai 
#SBATCH --gres=gpu:tesla_v100:1 
#SBATCH --mem=50G 
#SBATCH --time=7-0:0:0 # Time limit days-hours:minutes:seconds
#SBATCH --output=test-%j.out # Standard output and error log


echo "Setting stack size to unlimited..."
ulimit -s unlimited
ulimit -l unlimited
ulimit -a
echo

source /xxxxx/bin/activate erbrd

nvidia-smi

python mlp_mnist_bp.py --pickle_name "FCMNIST7Seed1.pkl" --test_file_name "FCMNIST7SeedTest.pkl" --CMSE_FORWARD 0.005 --INPUT_SCALE 1.0 --OUTPUT_SCALE 1.0 --CMSE_OUTV 20000.0 --CMSE_HIDDENV 18000 18000 18000 --Reh_initialization_gain 1e-2 --Reh_initialization_gain2 1e-2 --WEIGHT_SCALE 0.75 0.75 0.75 --bias_lr_scale 0 --g_exp 1.0  --proj_update_period 10000000 --Reh_lambda 0.999999 --WEIGHT_SPARSITYV 55 --SEED_V 10

python mlp_mnist_bp.py --pickle_name "FCMNIST7Seed1.pkl" --test_file_name "FCMNIST7SeedTest.pkl" --CMSE_FORWARD 0.005 --INPUT_SCALE 1.0 --OUTPUT_SCALE 1.0 --CMSE_OUTV 20000.0 --CMSE_HIDDENV 18000 18000 18000 --Reh_initialization_gain 1e-2 --Reh_initialization_gain2 1e-2 --WEIGHT_SCALE 0.75 0.75 0.75 --bias_lr_scale 0 --g_exp 1.0  --proj_update_period 10000000 --Reh_lambda 0.999999 --WEIGHT_SPARSITYV 55 --SEED_V 11

python mlp_mnist_bp.py --pickle_name "FCMNIST7Seed1.pkl" --test_file_name "FCMNIST7SeedTest.pkl" --CMSE_FORWARD 0.005 --INPUT_SCALE 1.0 --OUTPUT_SCALE 1.0 --CMSE_OUTV 20000.0 --CMSE_HIDDENV 18000 18000 18000 --Reh_initialization_gain 1e-2 --Reh_initialization_gain2 1e-2 --WEIGHT_SCALE 0.75 0.75 0.75 --bias_lr_scale 0 --g_exp 1.0  --proj_update_period 10000000 --Reh_lambda 0.999999 --WEIGHT_SPARSITYV 55 --SEED_V 12

python mlp_mnist_bp.py --pickle_name "FCMNIST7Seed1.pkl" --test_file_name "FCMNIST7SeedTest.pkl" --CMSE_FORWARD 0.005 --INPUT_SCALE 1.0 --OUTPUT_SCALE 1.0 --CMSE_OUTV 20000.0 --CMSE_HIDDENV 18000 18000 18000 --Reh_initialization_gain 1e-2 --Reh_initialization_gain2 1e-2 --WEIGHT_SCALE 0.75 0.75 0.75 --bias_lr_scale 0 --g_exp 1.0  --proj_update_period 10000000 --Reh_lambda 0.999999 --WEIGHT_SPARSITYV 55 --SEED_V 13

python mlp_mnist_bp.py --pickle_name "FCMNIST7Seed1.pkl" --test_file_name "FCMNIST7SeedTest.pkl" --CMSE_FORWARD 0.005 --INPUT_SCALE 1.0 --OUTPUT_SCALE 1.0 --CMSE_OUTV 20000.0 --CMSE_HIDDENV 18000 18000 18000 --Reh_initialization_gain 1e-2 --Reh_initialization_gain2 1e-2 --WEIGHT_SCALE 0.75 0.75 0.75 --bias_lr_scale 0 --g_exp 1.0  --proj_update_period 10000000 --Reh_lambda 0.999999 --WEIGHT_SPARSITYV 55 --SEED_V 14


source deactivate
