if [ -z $1 ] ; then
	echo  "Please provide the device to run the experiments."
	exit 1
fi
# APP G H
if test -d "/root/workspace/out/chain_ab/"; then
	echo "Dir exist: /root/workspace/out/chain_ab/"
else
	echo "Making dir: /root/workspace/out/chain_ab/"
	mkdir /root/workspace/out/chain_ab/
fi
for seed in 0 42 1021 2022 2333
do  
	if test -d "/root/workspace/out/chain_ab/seed$seed/"; then
		echo "Dir exist: /root/workspace/out/chain_ab/seed$seed/"
	else
		echo "Making dir: /root/workspace/out/chain_ab/seed$seed/"
		mkdir /root/workspace/out/chain_ab/seed$seed/
	fi

	for n in 1 2 3 4 5
	do  
		if test -f "/root/workspace/out/chain_ab/seed$seed/n$n.log"; then
			echo "Not over-writing /root/workspace/out/chain_ab/seed$seed/n$n.log"
		else
			echo "Generating /root/workspace/out/chain_ab/seed$seed/n$n.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len 140 \
			--model MIGNN --adj_pow 1 --epochs 1000 --seed $seed \
			--lin_module cayley --inv_method neumann-$n --kappa .999 \
			--fp_method pr+a --fp_tol 1e-6 --alpha .9 --beta .9 \
			--clip 0 --dropout 0 --lr 0.01 \
			--num_class 3 > /root/workspace/out/chain_ab/seed$seed/n$n.log
		fi
	done
	for d in 1 2 3 4 5
	do
		if test -f "/root/workspace/out/chain_ab/seed$seed/d$d.log"; then
			echo "Not over-writing /root/workspace/out/chain_ab/seed$seed/d$d.log"
		else
			echo "Generating /root/workspace/out/chain_ab/seed$seed/d$d.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len 140 \
			--model MIGNN --adj_pow $d --epochs 1000 --seed $seed \
			--lin_module cayley --inv_method neumann-1 --kappa .999 \
			--fp_method pr+a --fp_tol 1e-6 --alpha .9 --beta .9 \
			--clip 0 --dropout 0 --lr 0.01 \
			--num_class 3 > /root/workspace/out/chain_ab/seed$seed/d$d.log
		fi
	done
done