if [ -z $1 ] ; then
	echo  "Please provide the device to run the experiments."
	exit 1
fi
# R1
if test -d "/root/workspace/out/chain_diff/"; then
	echo "Dir exist: /root/workspace/out/chain_diff/"
else
	echo "Making dir: /root/workspace/out/chain_diff/"
	mkdir /root/workspace/out/chain_diff/
fi
for len in 5 6 7 8 9 10
do  
	if test -d "/root/workspace/out/chain_diff/len$len/"; then
		echo "Dir exist: /root/workspace/out/chain_diff/len$len/"
	else
		echo "Making dir: /root/workspace/out/chain_diff/len$len/"
		mkdir /root/workspace/out/chain_diff/len$len/
	fi
	for seed in 0 42 1021 2022 2333
	do
		if test -d "/root/workspace/out/chain_diff/len$len/seed$seed/"; then
			echo "Dir exist: /root/workspace/out/chain_diff/len$len/seed$seed/"
		else
			echo "Making dir: /root/workspace/out/chain_diff/len$len/seed$seed/"
			mkdir /root/workspace/out/chain_diff/len$len/seed$seed/
		fi
        for d in 1 3 5
        do
            if test -f "/root/workspace/out/chain_diff/len$len/seed$seed/gcn$d.log"; then
                echo "Not over-writing /root/workspace/out/chain_diff/len$len/seed$seed/gcn$d.log"
            else
                echo "Generating /root/workspace/out/chain_diff/len$len/seed$seed/gcn$d.log"
                CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len \
                --model MIGNN --adj_pow $d --epochs 500 --seed $seed \
                --model GCN \
                > /root/workspace/out/chain_diff/len$len/seed$seed/gcn$d.log
            fi
            if test -f "/root/workspace/out/chain_diff/len$len/seed$seed/mon$d.log"; then
                echo "Not over-writing /root/workspace/out/chain_diff/len$len/seed$seed/mon$d.log"
            else
                echo "Generating /root/workspace/out/chain_diff/len$len/seed$seed/mon$d.log"
                CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len \
                --model MIGNN --adj_pow $d --epochs 500 --seed $seed \
                --lin_module symm --kappa .$d \
                --fp_method pr+a --inv_method neumann-5 \
                --fp_tol 1e-6 --alpha .5 --beta .9 \
                --lr 0.01 \
                > /root/workspace/out/chain_diff/len$len/seed$seed/mon$d.log
            fi
            if test -f "/root/workspace/out/chain_diff/len$len/seed$seed/ignn$d.log"; then
                echo "Not over-writing /root/workspace/out/chain_diff/len$len/seed$seed/ignn$d.log"
            else
                echo "Generating /root/workspace/out/chain_diff/len$len/seed$seed/ignn$d.log"
                CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len \
                --model IGNN --adj_pow $d --epochs 500 --seed $seed \
                --lin_module proj --kappa .999 \
                --fp_method pwr --fp_tol 1e-6 \
                --lr 0.01 \
                > /root/workspace/out/chain_diff/len$len/seed$seed/ignn$d.log
            fi
        done
	done
done