if [ -z $1 ] ; then
	echo  "Please provide the device to run the experiments."
	exit 1
fi

if test -d "/root/workspace/out/long_graph/"; then
	echo "Dir exist: /root/workspace/out/long_graph/"
else
	echo "Making dir: /root/workspace/out/long_graph/"
	mkdir /root/workspace/out/long_graph/
fi
for dataset in MUTAG PTC COX2 PROTEINS NCI1
do  
	if test -d "/root/workspace/out/long_graph/$dataset/"; then
		echo "Dir exist: /root/workspace/out/long_graph/$dataset/"
	else
		echo "Making dir: /root/workspace/out/long_graph/$dataset/"
		mkdir /root/workspace/out/long_graph/$dataset/
	fi
	for n in 1 2 3 4 5
	do
		if test -f "/root/workspace/out/long_graph/$dataset/n$n.log"; then
			echo "Not over-writing /root/workspace/out/long_graph/$dataset/n$n.log"
		else
			echo "Generating /root/workspace/out/long_graph/$dataset/n$n.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/graph_class.py \
			--model MIGNN --lin_module cayley --epochs 500 \
			--fp_method pr+a --inv_method neumann-$n --adj_pow 1 \
			--dataset $dataset --normalization AugNorm \
			> /root/workspace/out/long_graph/$dataset/n$n.log
		fi
	done
	for d in 1 2 3 4 5
	do
		if test -f "/root/workspace/out/long_graph/$dataset/d$d.log"; then
			echo "Not over-writing /root/workspace/out/long_graph/$dataset/d$d.log"
		else
			echo "Generating /root/workspace/out/long_graph/$dataset/d$d.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/graph_class.py \
			--model MIGNN --lin_module cayley --epochs 500 \
			--fp_method pr+a --inv_method neumann-1 --adj_pow $d \
			--dataset $dataset --normalization AugNorm \
			> /root/workspace/out/long_graph/$dataset/d$d.log
		fi
	done
done