if [ -z $1 ] ; then
	echo  "Please provide the device to run the experiments."
	exit 1
fi
# SEC 1.1 5.1
# APP I
if test -d "/root/workspace/out/twoclass/"; then
	echo "Dir exist: /root/workspace/out/twoclass/"
else
	echo "Making dir: /root/workspace/out/twoclass/"
	mkdir /root/workspace/out/twoclass/
fi
for len in 50 100 150 200 250 300
do  
	if test -d "/root/workspace/out/twoclass/len$len/"; then
		echo "Dir exist: /root/workspace/out/twoclass/len$len/"
	else
		echo "Making dir: /root/workspace/out/twoclass/len$len/"
		mkdir /root/workspace/out/twoclass/len$len/
	fi
	for seed in 0 42 1021 2022 2333
	do
		if test -d "/root/workspace/out/twoclass/len$len/seed$seed/"; then
			echo "Dir exist: /root/workspace/out/twoclass/len$len/seed$seed/"
		else
			echo "Making dir: /root/workspace/out/twoclass/len$len/seed$seed/"
			mkdir /root/workspace/out/twoclass/len$len/seed$seed/
		fi
		
		#N3D3
		if test -f "/root/workspace/out/twoclass/len$len/seed$seed/n3d3.log"; then
			echo "Not over-writing /root/workspace/out/twoclass/len$len/seed$seed/n3d3.log"
		else
			echo "Generating /root/workspace/out/twoclass/len$len/seed$seed/n3d3.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len \
			--model MIGNN --adj_pow 3 --epochs 500 --seed $seed \
			--lin_module cayley --inv_method neumann-3 --kappa .999 \
			--fp_method pr+a --fp_tol 1e-6 --alpha .9 --beta .9 \
			--clip 0 --dropout 0 --lr 0.01 \
			> /root/workspace/out/twoclass/len$len/seed$seed/n3d3.log
		fi

		#N3D5
		if test -f "/root/workspace/out/twoclass/len$len/seed$seed/n3d5.log"; then
			echo "Not over-writing /root/workspace/out/twoclass/len$len/seed$seed/n3d5.log"
		else
			echo "Generating /root/workspace/out/twoclass/len$len/seed$seed/n3d5.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len \
			--model MIGNN --adj_pow 5 --epochs 500 --seed $seed \
			--lin_module cayley --inv_method neumann-3 --kappa .999 \
			--fp_method pr+a --fp_tol 1e-6 --alpha .9 --beta .9 \
			--clip 0 --dropout 0 --lr 0.01 \
			> /root/workspace/out/twoclass/len$len/seed$seed/n3d5.log
		fi

		# IGNN
		if test -f "/root/workspace/out/twoclass/len$len/seed$seed/IGNN.log"; then
			echo "Not over-writing /root/workspace/out/twoclass/len$len/seed$seed/IGNN.log"
		else
			echo "Generating /root/workspace/out/twoclass/len$len/seed$seed/IGNN.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len --epochs 500 --seed $seed --kappa .999 \
			--model IGNN --lin_module proj --dropout 0 > /root/workspace/out/twoclass/len$len/seed$seed/IGNN.log
		fi

		# IGNN D5
		if test -f "/root/workspace/out/twoclass/len$len/seed$seed/IGNNd5.log"; then
			echo "Not over-writing /root/workspace/out/twoclass/len$len/seed$seed/IGNNd5.log"
		else
			echo "Generating /root/workspace/out/twoclass/len$len/seed$seed/IGNNd5.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len --epochs 500 --seed $seed --kappa .999 \
			--model IGNN --lin_module proj --dropout 0 --adj_pow 5 > /root/workspace/out/twoclass/len$len/seed$seed/IGNNd5.log
		fi
	done
done