# Monotone Operator Splitting Implicit Graph Neural Network

Monotone operator deq is joined with IGNN to accellerate convergence to the fixed point in the following problem.

$$  Z^* := \phi(W Z^* A + \Omega(X))$$

Where $W$ is paremeterized matrix, $A$ is a matrix representative of the graph, $\Omega$ is a linear function of the input features and generally includes $A$, and $\phi(Z)$ is the ReLU function.

# Configuration
## Installation
The recommended environment is provided via the `Dockerfile`.
```bash
nvidia-docker build --rm --no-cache -t mignn_img -f Dockerfile .
nvidia-docker run --rm -ti --ipc=host mignn_img /bin/bash
```

The `mono_ignn` library can be installed using `pip` or `pip3`
``` bash
pip3 install -e .
```

The recommended directory structure is 
``` bash
.
└─ root
    └── workspace
        ├── data
        ├── mono_ignn
        └── out
```

To run either the porous media examples or the citation examples, please use `git clone` to copy the following repositories into `mono_ignn/other/`

```bash
https://github.com/Junyoungpark/CGS.git
https://github.com/7qchen/GIND.git
```

Your structure should look like

``` bash
.
└─ root
    └── workspace
        ├── data
        ├── mono_ignn
        |   └── mono_ignn
        |       |   ...
        |       └── other
                    |   ...
        |           ├── CGS
        |           └── GIND
        |   ...
        └── out
```


## Data

External datsets can be found [here](https://drive.google.com/file/d/1cc6ViFbrMu0ws__i2-OLoBVRhM3BV3I2/view?usp=sharing). Internal datasets are automatically downloaded at runtime. 

*External*: `amazon-all`, `amazon-top5000`

*Internal*: `MUTAG`, ...


## Reproducing

**Bash**

Bash files are provided in the directory `mono_ignn/bin/` these provide pre-configured expirement setups and directory configuration. The scripts require one commandline argument that tells the bash file which `cuda-device` to use by **integer number**.

```bash
bash ./bin/amazon/cayley_MIGNN.sh 0
```

**Python**

Alternatively all examples are found in the `mono_ignn/examples/` and can be called using commandline options. For details on the available options use flag `-h`.

```bash
python3 ./examples/chains.py -h
```

# Features

The `mono_ignn` library provides three new components to the *implicit graph* architecture.

    1. Parametrizations of W.
    2. Accelerated fixed point convergence.
    3. Resolvent approximation.

## Parameterizations of $W$

To assure fixed point convergence several parametrizations of $W$ are possible and discussed in [our_text](https://www.google.com). An optionally learned parameter $\mu$ may be used to constrain the eigenvalues of $W$.

| **Flag** | **Parametrization** |
| --- | --- |
| `cayley`| $\sigma(\mu)(I+B)(I-B)^{-1} D$ |
| `expm`| $\sigma(\mu)\bf{B\exp(B^{-1}C})$ |
| `frob`| $\sigma(\mu)\frac{BB^T}{\lVert BB^T \rVert_F +\varepsilon}$ |
| `proj`| $\lVert W\rVert_F < \lambda_{pf}(A)^{-1}$ |
| `symm`| $\frac{1-e^{\mu}}{2}I-BB^T$ |
| `skew`| $\frac{1-e^{\mu}}{2}I-BB^T-C+C^T$ |


## Accelerated Fixed Point Convergence

Each of the fixed point solving methods can be found in `mono_ignn.mignn.solvers` several of these are operator splitting methods (OSM). Operator splitting methods require the [residual operator](#order-reduction-of-the-residual-operator). In addition several of the methods can be called with further acceleration schemes. The two acceleration schemes implemented are [Anderson Acceleration](https://www.google.com) and [Halpern Acceleration](https://www.google.com).

| **Class** | **OSM** | **Accelerated** |
| --- | --- | --- |
|  `DouglasRachford` | :white_check_mark: | :x: |
|  `DouglasRachfordAnderson` | :white_check_mark: | :white_check_mark: |
|  `DouglasRachfordHalpern` | :white_check_mark: | :white_check_mark: |
| | | 
|  `ForwardBackward` | :white_check_mark: | :x: |
|  `ForwardBackwardAnderson` | :white_check_mark: | :white_check_mark: |
| | | 
|  `PeacemanRachford` | :white_check_mark: | :x: |
|  `PeacemanRachfordAnderson` | :white_check_mark: | :white_check_mark: |
| | | 
|  `PowerMethod` | :x: | :x: |
|  `PowerMethodAnderson` | :x: | :white_check_mark: |


## Resolvent Approximations

The operator splitting methods and their accelerated counterparts require the residual operator 

$$V=(I+\alpha (I-A^T\otimes W))^{-1}.$$

If the graph is very large this direct inverse calculation will be exceptionally expensive. Alternative methods for reducing the order of the model given in `mono_ignn.mignn.regularization` are depicted below.


| **Method** | **Flag** | **Numerical Scheme** | **Expense** |
| --- | --- | --- | --- |
| Direct Inverse | `direct` | $(I+\alpha (I-A^T\otimes W))^{-1}$ | $\mathcal{O}(m^3n^3)$ |
| Eigen Decomposition | `eig` | $Q_{A^T} Q_S^T(G\circ (Q_{A^T}(\cdot) Q_S^T))Q_S$ | $\mathcal{O}(\text{max}[m^3,n^3])$ |
| Neumann Expansion | `neumann-k` | $I+W(\cdot)A+\dots+W^k(\cdot)A^k$ | $\mathcal{O}(\text{max}[km^2,kn^2])$ |