if [ -z $1 ] ; then
	echo  "Please provide the device to run the experiments."
	exit 1
fi
if test -d "/root/workspace/out/citations/"; then
	echo "Dir exist: /root/workspace/out/citations/"
else
	echo "Making dir: /root/workspace/out/citations"
	mkdir /root/workspace/out/citations/
fi
for dataset in cora
do
    if test -d "/root/workspace/out/citations/$dataset/"; then
        echo "Dir exist: /root/workspace/out/citations/$dataset/"
    else
        echo "Making dir: /root/workspace/out/citations/$dataset/"
        mkdir /root/workspace/out/citations/$dataset/
    fi
    for d in 01 007 005 002 001 0005 0001
    do  
        if test -f "/root/workspace/out/citations/$dataset/symm$d.log"; then
            echo "Not over-writing /root/workspace/out/citations/$dataset/symm$d.log"
        else
            echo "Generating /root/workspace/out/citations/$dataset/symm$d.log"
            CUDA_VISIBLE_DEVICES=$1 ./examples/citations/citation_2.py dataset=$dataset \
            params.$dataset.imp_lr=.$d \
            params.$dataset.architecture.alpha=0.5 \
            params.$dataset.architecture.mu0=-1 \
            params.$dataset.architecture.linModule=skew \
            params.$dataset.architecture.fp_tol=1e-3 \
            params.$dataset.imp_wd=1e-4 \
            params.$dataset.norm=LaplaceNorm \
            params.$dataset.architecture.hidden_channels=64 \
            > /root/workspace/out/citations/$dataset/symm$d.log
        fi
    done
    # for n in 1 2 3 4 5 
    # do
    #     if test -f "/root/workspace/out/citations/$dataset/cayl_n$n.log"; then
    #         echo "Not over-writing /root/workspace/out/citations/$dataset/cayl_n$n.log"
    #     else
    #         echo "Generating /root/workspace/out/citations/$dataset/cayl_n$n.log"
    #         CUDA_VISIBLE_DEVICES=$1 ./examples/citations/citation_2.py dataset=$dataset \
    #         params.$dataset.architecture.alpha=0.2 \
    #         params.$dataset.imp_lr=0.01 \
    #         params.$dataset.imp_wd=1e-4 \
    #         params.$dataset.architecture.hidden_channels=64 \
    #         params.$dataset.architecture.linModule=cayley \
    #         params.$dataset.architecture.fpMethod=pr \
    #         params.$dataset.architecture.invMethod=neumann-$n \
    #         > /root/workspace/out/citations/$dataset/cayl_n$n.log
    #     fi
    # done
    # for d in 2 3 4 5 
    # do
    #     if test -f "/root/workspace/out/citations/$dataset/cayl_d$d.log"; then
    #         echo "Not over-writing /root/workspace/out/citations/$dataset/cayl_d$d.log"
    #     else
    #         echo "Generating /root/workspace/out/citations/$dataset/cayl_d$d.log"
    #         CUDA_VISIBLE_DEVICES=$1 ./examples/citations/citation_2.py dataset=$dataset \
    #         params.$dataset.adj_pow=$d \
    #         params.$dataset.architecture.alpha=0.2 \
    #         params.$dataset.imp_lr=0.008 \
    #         params.$dataset.imp_wd=1e-4 \
    #         params.$dataset.architecture.hidden_channels=64 \
    #         params.$dataset.architecture.linModule=cayley \
    #         params.$dataset.architecture.fpMethod=pr \
    #         params.$dataset.architecture.invMethod=neumann-1 \
    #         > /root/workspace/out/citations/$dataset/cayl_d$d.log
    #     fi
    # done
    # for d in 1 2 3 4 5
    # do  
    #     if test -f "/root/workspace/out/citations/$dataset/cayl$d.log"; then
    #         echo "Not over-writing /root/workspace/out/citations/$dataset/cayl$d.log"
    #     else
    #         echo "Generating /root/workspace/out/citations/$dataset/cayl$d.log"
    #         CUDA_VISIBLE_DEVICES=$1 ./examples/citations/citation_2.py dataset=$dataset \
    #         params.$dataset.imp_lr=0.008 \
    #         params.$dataset.architecture.alpha=0.1 \
    #         params.$dataset.imp_wd=1e-4 \
    #         params.$dataset.architecture.hidden_channels=64 \
    #         params.$dataset.architecture.linModule=cayley \
    #         params.$dataset.architecture.fpMethod=pr \
    #         params.$dataset.architecture.invMethod=neumann-$d \
    #         > /root/workspace/out/citations/$dataset/cayl$d.log
    #     fi
    # done
done