if [ -z $1 ] ; then
	echo  "Please provide the device to run the experiments."
	exit 1
fi
# SEC 1.1 5.1
# APP I
if test -d "/root/workspace/out/multiclass/"; then
	echo "Dir exist: /root/workspace/out/multiclass/"
else
	echo "Making dir: /root/workspace/out/multiclass/"
	mkdir /root/workspace/out/multiclass/
fi
for len in 20 40 60 80 100 110 120 130 140 150 160 170 180 190 200
do  
	if test -d "/root/workspace/out/multiclass/len$len/"; then
		echo "Dir exist: /root/workspace/out/multiclass/len$len/"
	else
		echo "Making dir: /root/workspace/out/multiclass/len$len/"
		mkdir /root/workspace/out/multiclass/len$len/
	fi
	for seed in 0 42 1021 2022 2333
	do
		if test -d "/root/workspace/out/multiclass/len$len/seed$seed/"; then
			echo "Dir exist: /root/workspace/out/multiclass/len$len/seed$seed/"
		else
			echo "Making dir: /root/workspace/out/multiclass/len$len/seed$seed/"
			mkdir /root/workspace/out/multiclass/len$len/seed$seed/
		fi

		# N3D3
		if test -f "/root/workspace/out/multiclass/len$len/seed$seed/n3d3.log"; then
			echo "Not over-writing /root/workspace/out/multiclass/len$len/seed$seed/n3d3.log"
		else
			echo "Generating /root/workspace/out/multiclass/len$len/seed$seed/n3d3.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len \
			--model MIGNN --adj_pow 3 --epochs 500 --seed $seed \
			--lin_module cayley --inv_method neumann-3 --kappa .999 \
			--fp_method pr+a --fp_tol 1e-6 --alpha .9 --beta .9 \
			--clip 0 --dropout 0 --lr 0.01 \
			--num_class 3 > /root/workspace/out/multiclass/len$len/seed$seed/n3d3.log
		fi

		# N3D5
		if test -f "/root/workspace/out/multiclass/len$len/seed$seed/n3d5.log"; then
			echo "Not over-writing /root/workspace/out/multiclass/len$len/seed$seed/n3d5.log"
		else
			echo "Generating /root/workspace/out/multiclass/len$len/seed$seed/n3d5.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len \
			--model MIGNN --adj_pow 5 --epochs 500 --seed $seed \
			--lin_module cayley --inv_method neumann-3 --kappa .999 \
			--fp_method pr+a --fp_tol 1e-6 --alpha .9 --beta .9 \
			--clip 0 --dropout 0 --lr 0.01 \
			--num_class 3 > /root/workspace/out/multiclass/len$len/seed$seed/n3d5.log
		fi

		# IGNN
		if test -f "/root/workspace/out/multiclass/len$len/seed$seed/IGNN.log"; then
			echo "Not over-writing /root/workspace/out/multiclass/len$len/seed$seed/IGNN.log"
		else
			echo "Generating /root/workspace/out/multiclass/len$len/seed$seed/IGNN.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len --epochs 500 --seed $seed --kappa .999 \
			--model IGNN --lin_module proj --dropout 0 --num_class 3 \
			> /root/workspace/out/multiclass/len$len/seed$seed/IGNN.log
		fi

		# IGNN D5
		if test -f "/root/workspace/out/multiclass/len$len/seed$seed/IGNNd5.log"; then
			echo "Not over-writing /root/workspace/out/multiclass/len$len/seed$seed/IGNNd5.log"
		else
			echo "Generating /root/workspace/out/multiclass/len$len/seed$seed/IGNNd5.log"
			CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len $len --epochs 500 --seed $seed --kappa .999 \
			--model IGNN --lin_module proj --dropout 0 --adj_pow 5 --num_class 3 \
			> /root/workspace/out/multiclass/len$len/seed$seed/IGNNd5.log
		fi
	done
done


# N2D5
if test -f "/root/workspace/out/multiclass/len140/seed2333/n2d5.log"; then
	echo "Not over-writing /root/workspace/out/multiclass/len140/seed2333/n2d5.log"
else
	echo "Generating /root/workspace/out/multiclass/len140/seed2333/n2d5.log"
	CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len 140 \
	--model MIGNN --adj_pow 5 --epochs 1000 --seed 2333 \
	--lin_module cayley --inv_method neumann-2 --kappa .999 \
	--fp_method pr+a --fp_tol 1e-6 --alpha .9 --beta .9 \
	--clip 0 --dropout 0 --lr 0.01 \
	--num_class 3 > /root/workspace/out/multiclass/len140/seed2333/n2d5.log
fi


# IGNN LONG
if test -f "/root/workspace/out/multiclass/len140/seed2333/ignn_long.log"; then
	echo "Not over-writing /root/workspace/out/multiclass/len140/seed2333/ignn_long.log"
else
	echo "Generating /root/workspace/out/multiclass/len140/seed2333/ignn_long.log"
		CUDA_VISIBLE_DEVICES=$1 ./examples/chains.py --chain_len 140 --epochs 1000 --seed 2333 --kappa .999 \
		--model IGNN --lin_module proj --dropout 0 --num_class 3 \
		> /root/workspace/out/multiclass/len140/seed2333/ignn_long.log
fi



