import gym
import numpy as np

# Import the Mujoco Pusher environment
from gym.envs.mujoco import PusherEnv

# Subclass the Pusher environment
class ActionPenalizedPusher(PusherEnv):
    def __init__(self, action_penalty=0):
        self.action_penalty = action_penalty
        super().__init__()

    def step(self, a):
        vec_1 = self.get_body_com("object") - self.get_body_com("tips_arm")
        vec_2 = self.get_body_com("object") - self.get_body_com("goal")
        
        reward_near = -np.linalg.norm(vec_1)
        reward_dist = -np.linalg.norm(vec_2)
        reward_ctrl = -np.square(a).sum()
        reward = reward_dist + self.action_penalty * reward_ctrl + 0.5 * reward_near

        self.do_simulation(a, self.frame_skip)
        if self.render_mode == "human":
            self.render()

        ob = self._get_obs()
        return (ob, reward, False, False, dict(reward_dist=reward_dist, reward_ctrl=reward_ctrl))
