import numpy as np

class PD:
    def __init__(self, action_dim: int, kp: float, kd: float):
        self.kp, self.kd = kp, kd
        self.action_dim = action_dim
        self.last_error = np.zeros(self.action_dim)

    def reset(self):
        self.last_error.fill(0)

    # Dynamically pass the set point (target) and feedback to compute the control action
    def action(self, set_point: np.array):
        # Calculate the error dynamically based on current set point and feedback
        error = set_point

        # Proportional term
        proportional = self.kp * error

        # Derivative term
        derivative = self.kd * (error - self.last_error)

        # Update last error for next step
        self.last_error = error

        # Compute the final output
        output = proportional + derivative

        return np.clip(output, -1, 1), {'proportional': proportional, 'derivative': derivative}


if __name__ == "__main__":
    # Example usage
    pid_controller = PD(kp=1.0, kd=0.05, action_dim=2)
    feedback = np.array([2.0, 1.2])  # Current state or feedback from the environment
    set_point = np.array([5.0, 2.5])  # Dynamic target or desired state

    output, components = pid_controller.action(set_point)
    print("Control Output:", output)
    print("Components:", components)
